/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.client;

import com.google.gwtorm.client.Key;

public class KeyUtil {
    private static Encoder ENCODER_IMPL;

    public static void setEncoderImpl(Encoder e) {
        ENCODER_IMPL = e;
    }

    public static <T extends Key<?>> boolean eq(T a, T b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public static String encode(String e) {
        return ENCODER_IMPL.encode(e);
    }

    public static String decode(String e) {
        return ENCODER_IMPL.decode(e);
    }

    public static String parseFromString(Key<?> parent, String in) {
        int comma = in.lastIndexOf(44);
        if (comma < 0 && parent == null) {
            return KeyUtil.decode(in);
        }
        if (comma < 0 && parent != null) {
            throw new IllegalArgumentException("Not enough components: " + in);
        }
        assert (parent != null);
        parent.fromString(in.substring(0, comma));
        return KeyUtil.decode(in.substring(comma + 1));
    }

    private KeyUtil() {
    }

    public static abstract class Encoder {
        public abstract String encode(String var1);

        public abstract String decode(String var1);
    }
}

