/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.jdbc;

import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.jdbc.AccessGen;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.java.JavaSchemaModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import com.google.gwtorm.server.SchemaConstructorGen;
import com.google.gwtorm.server.SchemaFactory;
import com.google.gwtorm.server.SchemaGen;
import com.google.gwtorm.server.StandardKeyEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class Database<T extends Schema>
implements SchemaFactory<T> {
    private final DataSource dataSource;
    private final JavaSchemaModel schemaModel;
    private final SchemaFactory<T> implFactory;
    private final SqlDialect implDialect;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(DataSource ds, Class<T> schema) throws OrmException {
        SqlDialect dialect;
        this.dataSource = ds;
        try (Connection c = ds.getConnection();){
            dialect = SqlDialect.getDialectFor(c);
        }
        catch (SQLException e) {
            throw new OrmException("Unable to determine SqlDialect", e);
        }
        this.schemaModel = new JavaSchemaModel(schema);
        GeneratedClassLoader loader = Database.newLoader(schema);
        Class<T> impl = this.generate(dialect, loader);
        this.implFactory = new SchemaConstructorGen<T>(loader, impl, this).create();
        this.implDialect = dialect;
    }

    private Class<T> generate(final SqlDialect dialect, GeneratedClassLoader loader) throws OrmException {
        return new SchemaGen<JdbcSchema>(loader, this.schemaModel, this.getClass(), JdbcSchema.class, new SchemaGen.AccessGenerator(){

            @Override
            public Class<?> create(GeneratedClassLoader loader, RelationModel rm) throws OrmException {
                return new AccessGen(loader, rm, dialect).create();
            }
        }).create();
    }

    SqlDialect getDialect() {
        return this.implDialect;
    }

    SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    @Override
    public T open() throws OrmException {
        return this.implFactory.open();
    }

    Connection newConnection() throws OrmException {
        Connection conn;
        try {
            conn = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new OrmException("Cannot open database connection", e);
        }
        try {
            if (!conn.getAutoCommit()) {
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OrmException("Cannot force auto-commit on connection", e);
        }
        return conn;
    }

    private static <T> GeneratedClassLoader newLoader(Class<T> schema) {
        return new GeneratedClassLoader(schema.getClassLoader());
    }

    static {
        KeyUtil.setEncoderImpl(new StandardKeyEncoder());
    }
}

