/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.nosql.IndexFunction;
import com.google.gwtorm.nosql.IndexFunctionGen;
import com.google.gwtorm.nosql.IndexKeyBuilder;
import com.google.gwtorm.nosql.NoSqlAccess;
import com.google.gwtorm.nosql.NoSqlSchema;
import com.google.gwtorm.nosql.RelationCodec;
import com.google.gwtorm.protobuf.CodecFactory;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.KeyModel;
import com.google.gwtorm.schema.QueryModel;
import com.google.gwtorm.schema.QueryParser;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.CodeGenSupport;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.Tree;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

class AccessGen
implements Opcodes {
    private static final Type string = Type.getType(String.class);
    private static final Type protobufCodec = Type.getType(ProtobufCodec.class);
    private static final Type indexFunction = Type.getType(IndexFunction.class);
    private static final Type object = Type.getType(Object.class);
    private static final Type ormKey = Type.getType(Key.class);
    private static final Type byteArray = Type.getType(byte[].class);
    private static final Type ormException = Type.getType(OrmException.class);
    private static final Type resultSet = Type.getType(ResultSet.class);
    private static final Type indexKeyBuilder = Type.getType(IndexKeyBuilder.class);
    private static final String F_OBJECT_CODEC = "objectCodec";
    private static final String F_INDEXES = "indexes";
    private final GeneratedClassLoader classLoader;
    private final RelationModel model;
    private final Class<?> modelClass;
    private final Type schemaType;
    private final Type accessType;
    private final Type entityType;
    private final KeyModel key;
    private ClassWriter cw;
    private String implClassName;
    private String implTypeName;

    AccessGen(GeneratedClassLoader loader, RelationModel rm, Class<? extends NoSqlSchema> schemaClazz, Class<? extends NoSqlAccess> accessClazz) throws OrmException {
        this.classLoader = loader;
        this.model = rm;
        try {
            this.modelClass = Class.forName(this.model.getEntityTypeClassName(), true, this.classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            throw new OrmException("Cannot locate model class", cnfe);
        }
        this.schemaType = Type.getType(schemaClazz);
        this.accessType = Type.getType(accessClazz);
        this.entityType = Type.getType(this.modelClass);
        this.key = this.model.getPrimaryKey();
        if (this.key == null) {
            throw new OrmException("Relation " + rm.getMethodName() + " has no primary key");
        }
    }

    Class<?> create() throws OrmException {
        this.init();
        this.implementStaticFields();
        this.implementConstructor();
        this.implementGetString("getRelationName", this.model.getRelationName());
        this.implementGetRelationID();
        this.implementGetObjectCodec();
        this.implementGetIndexes();
        this.implementPrimaryKey();
        this.implementEncodePrimaryKey();
        this.implementKeyQuery(this.key);
        for (QueryModel q : this.model.getQueries()) {
            this.implementQuery(q);
        }
        this.implementQuery(new QueryModel(this.model, "iterateAllEntities", ""));
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
        Class<?> c = this.loadClass();
        this.initObjectCodec(c);
        this.initQueryIndexes(c);
        return c;
    }

    private void initObjectCodec(Class<?> clazz) throws OrmException {
        ProtobufCodec<?> oc = CodecFactory.encoder(this.modelClass);
        if (this.model.getRelationID() > 0) {
            oc = new RelationCodec(this.model.getRelationID(), oc);
        }
        try {
            Field e = clazz.getDeclaredField(F_OBJECT_CODEC);
            e.setAccessible(true);
            e.set(null, oc);
        }
        catch (IllegalArgumentException err) {
            throw new OrmException("Cannot setup ProtobufCodec", err);
        }
        catch (IllegalStateException err) {
            throw new OrmException("Cannot setup ProtobufCodec", err);
        }
        catch (IllegalAccessException err) {
            throw new OrmException("Cannot setup ProtobufCodec", err);
        }
        catch (SecurityException err) {
            throw new OrmException("Cannot setup ProtobufCodec", err);
        }
        catch (NoSuchFieldException err) {
            throw new OrmException("Cannot setup ProtobufCodec", err);
        }
    }

    private void initQueryIndexes(Class<?> clazz) throws OrmException {
        Collection<QueryModel> queries = this.model.getQueries();
        ArrayList indexes = new ArrayList();
        for (QueryModel m : queries) {
            if (!this.needsIndexFunction(m)) continue;
            indexes.add(new IndexFunctionGen(this.classLoader, m, this.modelClass).create());
        }
        try {
            Field e = clazz.getDeclaredField(F_INDEXES);
            e.setAccessible(true);
            e.set(null, indexes.toArray(new IndexFunction[indexes.size()]));
            for (IndexFunction indexFunction : indexes) {
                e = clazz.getDeclaredField("index_" + indexFunction.getName());
                e.setAccessible(true);
                e.set(null, indexFunction);
            }
        }
        catch (IllegalArgumentException err) {
            throw new OrmException("Cannot setup query IndexFunctions", err);
        }
        catch (IllegalStateException err) {
            throw new OrmException("Cannot setup query IndexFunctions", err);
        }
        catch (IllegalAccessException err) {
            throw new OrmException("Cannot setup query IndexFunctions", err);
        }
        catch (SecurityException err) {
            throw new OrmException("Cannot setup query IndexFunctions", err);
        }
        catch (NoSuchFieldException err) {
            throw new OrmException("Cannot setup query IndexFunctions", err);
        }
    }

    private Class<?> loadClass() throws OrmException {
        try {
            return Class.forName(this.implClassName, false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new OrmException("Cannot load generated class", err);
        }
    }

    private void init() {
        this.implClassName = this.model.getEntityTypeClassName() + "_Access_" + this.model.getMethodName() + "_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, this.accessType.getInternalName(), new String[]{this.model.getAccessInterfaceName().replace('.', '/')});
    }

    private void implementStaticFields() {
        this.cw.visitField(10, F_OBJECT_CODEC, protobufCodec.getDescriptor(), null, null).visitEnd();
        this.cw.visitField(10, F_INDEXES, Type.getType(IndexFunction[].class).getDescriptor(), null, null).visitEnd();
        for (QueryModel q : this.model.getQueries()) {
            if (!this.needsIndexFunction(q)) continue;
            this.cw.visitField(10, "index_" + q.getName(), indexFunction.getDescriptor(), null, null).visitEnd();
        }
    }

    private void implementConstructor() {
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor(Type.VOID_TYPE, this.schemaType);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.accessType.getInternalName(), "<init>", consDesc);
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetString(String methodName, String returnValue) {
        MethodVisitor mv = this.cw.visitMethod(17, methodName, Type.getMethodDescriptor(string, new Type[0]), null, null);
        mv.visitCode();
        mv.visitLdcInsn(returnValue);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetRelationID() {
        MethodVisitor mv = this.cw.visitMethod(17, "getRelationID", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), null, null);
        mv.visitCode();
        new CodeGenSupport(mv).push(this.model.getRelationID());
        mv.visitInsn(172);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetObjectCodec() {
        MethodVisitor mv = this.cw.visitMethod(17, "getObjectCodec", Type.getMethodDescriptor(protobufCodec, new Type[0]), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.implTypeName, F_OBJECT_CODEC, protobufCodec.getDescriptor());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementGetIndexes() {
        MethodVisitor mv = this.cw.visitMethod(17, "getIndexes", Type.getMethodDescriptor(Type.getType(IndexFunction[].class), new Type[0]), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, this.implTypeName, F_INDEXES, Type.getType(IndexFunction[].class).getDescriptor());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementPrimaryKey() {
        ColumnModel f = this.key.getField();
        MethodVisitor mv = this.cw.visitMethod(17, "primaryKey", Type.getMethodDescriptor(ormKey, object), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, this.entityType.getInternalName());
        mv.visitFieldInsn(180, this.entityType.getInternalName(), f.getFieldName(), CodeGenSupport.toType(f).getDescriptor());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementEncodePrimaryKey() throws OrmException {
        List<ColumnModel> pCols = Collections.singletonList(this.key.getField());
        Type argType = CodeGenSupport.toType(this.key.getField());
        MethodVisitor mv = this.cw.visitMethod(17, "encodePrimaryKey", Type.getMethodDescriptor(Type.VOID_TYPE, indexKeyBuilder, ormKey), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, argType.getInternalName());
        mv.visitVarInsn(58, 2);
        QueryCGS cgs = new QueryCGS(mv, new Type[]{argType}, pCols, new int[]{2}, 1);
        for (ColumnModel f : pCols) {
            IndexFunctionGen.encodeField(new QueryModel.OrderBy(f, false), mv, cgs);
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementKeyQuery(KeyModel key) {
        Type keyType = CodeGenSupport.toType(key.getField());
        MethodVisitor mv = this.cw.visitMethod(17, key.getName(), Type.getMethodDescriptor(this.entityType, keyType), null, new String[]{Type.getType(OrmException.class).getInternalName()});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, this.accessType.getInternalName(), "get", Type.getMethodDescriptor(object, ormKey));
        mv.visitTypeInsn(192, this.entityType.getInternalName());
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementQuery(QueryModel info) throws OrmException {
        List<ColumnModel> pCols = info.getParameters();
        boolean hasLimitParam = info.hasLimitParameter();
        Type[] pTypes = new Type[pCols.size() + (hasLimitParam ? 1 : 0)];
        int[] pVars = new int[pTypes.length];
        int nextVar = 1;
        for (int i = 0; i < pCols.size(); ++i) {
            pTypes[i] = CodeGenSupport.toType(pCols.get(i));
            pVars[i] = nextVar;
            nextVar += pTypes[i].getSize();
        }
        if (hasLimitParam) {
            pTypes[pTypes.length - 1] = Type.INT_TYPE;
            pVars[pTypes.length - 1] = nextVar;
            nextVar += Type.INT_TYPE.getSize();
        }
        MethodVisitor mv = this.cw.visitMethod(17, info.getName(), Type.getMethodDescriptor(resultSet, pTypes), null, new String[]{ormException.getInternalName()});
        mv.visitCode();
        List<Tree> ops = this.compareOpsOnly(info.getParseTree());
        int fromBuf = nextVar++;
        mv.visitTypeInsn(187, indexKeyBuilder.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, indexKeyBuilder.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitVarInsn(58, fromBuf);
        QueryCGS cgs = new QueryCGS(mv, pTypes, pCols, pVars, fromBuf);
        this.encodeFields(info, ops, mv, cgs, true);
        int toBuf = nextVar++;
        mv.visitTypeInsn(187, indexKeyBuilder.getInternalName());
        mv.visitInsn(89);
        mv.visitMethodInsn(183, indexKeyBuilder.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitVarInsn(58, toBuf);
        cgs = new QueryCGS(mv, pTypes, pCols, pVars, toBuf);
        this.encodeFields(info, ops, mv, cgs, false);
        cgs.infinity();
        mv.visitVarInsn(25, 0);
        if (this.needsIndexFunction(info)) {
            mv.visitFieldInsn(178, this.implTypeName, "index_" + info.getName(), indexFunction.getDescriptor());
        }
        mv.visitVarInsn(25, fromBuf);
        mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), "toByteArray", Type.getMethodDescriptor(byteArray, new Type[0]));
        mv.visitVarInsn(25, toBuf);
        mv.visitMethodInsn(182, indexKeyBuilder.getInternalName(), "toByteArray", Type.getMethodDescriptor(byteArray, new Type[0]));
        if (info.hasLimit()) {
            if (hasLimitParam) {
                mv.visitVarInsn(21, pVars[pTypes.length - 1]);
            } else {
                cgs.push(info.getStaticLimit());
            }
        } else {
            cgs.push(0);
        }
        cgs.push(info.hasOrderBy() ? 1 : 0);
        if (this.needsIndexFunction(info)) {
            mv.visitMethodInsn(182, this.accessType.getInternalName(), "scanIndex", Type.getMethodDescriptor(resultSet, indexFunction, byteArray, byteArray, Type.INT_TYPE, Type.BOOLEAN_TYPE));
        } else {
            mv.visitMethodInsn(182, this.accessType.getInternalName(), "scanPrimaryKey", Type.getMethodDescriptor(resultSet, byteArray, byteArray, Type.INT_TYPE, Type.BOOLEAN_TYPE));
        }
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private boolean needsIndexFunction(QueryModel info) {
        return info.hasWhere() || info.hasOrderBy();
    }

    private void encodeFields(QueryModel qm, List<Tree> query, MethodVisitor mv, QueryCGS cgs, boolean fromKey) throws OrmException {
        boolean toKey = !fromKey;
        Tree lastNode = null;
        for (Tree node : query) {
            switch (node.getType()) {
                case 11: {
                    if (!fromKey) break;
                    this.checkLastNode(qm, lastNode);
                    this.encodeField(node, mv, cgs);
                    cgs.delimiter();
                    lastNode = node;
                    break;
                }
                case 10: {
                    if (!fromKey) break;
                    this.checkLastNode(qm, lastNode);
                    this.encodeField(node, mv, cgs);
                    cgs.delimiter();
                    cgs.infinity();
                    lastNode = node;
                    break;
                }
                case 12: {
                    this.checkLastNode(qm, lastNode);
                    this.encodeField(node, mv, cgs);
                    cgs.delimiter();
                    break;
                }
                case 9: {
                    if (!toKey) break;
                    this.checkLastNode(qm, lastNode);
                    this.encodeField(node, mv, cgs);
                    cgs.delimiter();
                    lastNode = node;
                    break;
                }
                case 8: {
                    if (!toKey) break;
                    this.checkLastNode(qm, lastNode);
                    this.encodeField(node, mv, cgs);
                    cgs.delimiter();
                    cgs.nul();
                    lastNode = node;
                    break;
                }
                default: {
                    throw new OrmException("Unsupported query token in " + this.model.getMethodName() + "." + qm.getName() + ": " + node.toStringTree());
                }
            }
            cgs.nextParameter();
        }
    }

    private void checkLastNode(QueryModel qm, Tree lastNode) throws OrmException {
        if (lastNode != null) {
            throw new OrmException(lastNode.getText() + " must be last operator in " + this.model.getMethodName() + "." + qm.getName());
        }
    }

    private void encodeField(Tree node, MethodVisitor mv, QueryCGS cgs) throws OrmException {
        ColumnModel f = ((QueryParser.Column)node.getChild(0)).getField();
        IndexFunctionGen.encodeField(new QueryModel.OrderBy(f, false), mv, cgs);
    }

    private List<Tree> compareOpsOnly(Tree node) throws OrmException {
        if (node == null) {
            return Collections.emptyList();
        }
        switch (node.getType()) {
            case 0: 
            case 4: 
            case 7: {
                ArrayList<Tree> res = new ArrayList<Tree>();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    res.addAll(this.compareOpsOnly(node.getChild(i)));
                }
                return res;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Tree lhs = node.getChild(0);
                Tree rhs = node.getChild(1);
                if (lhs.getType() != 13) {
                    throw new OrmException("Unsupported query token");
                }
                if (rhs.getType() != 14) break;
                return Collections.singletonList(node);
            }
            case 5: 
            case 18: {
                break;
            }
            default: {
                throw new OrmException("Unsupported query token " + node.toStringTree());
            }
        }
        return Collections.emptyList();
    }

    private final class QueryCGS
    extends IndexFunctionGen.EncodeCGS {
        private final Type[] pTypes;
        private final List<ColumnModel> pCols;
        private final int[] pVars;
        private final int bufvar;
        private int currentp;

        private QueryCGS(MethodVisitor method, Type[] pTypes, List<ColumnModel> pCols, int[] pVars, int bufvar) {
            super(method);
            this.pTypes = pTypes;
            this.pCols = pCols;
            this.pVars = pVars;
            this.bufvar = bufvar;
        }

        void nextParameter() {
            ++this.currentp;
        }

        @Override
        void pushBuilder() {
            this.mv.visitVarInsn(25, this.bufvar);
        }

        @Override
        public void pushFieldValue() {
            this.appendGetField(this.getFieldReference());
        }

        @Override
        protected void appendGetField(ColumnModel c) {
            if (this.currentp < this.pTypes.length && this.pCols.get(this.currentp).equals(c)) {
                this.loadVar(this.pTypes[this.currentp], this.pVars[this.currentp]);
            } else {
                super.appendGetField(c);
            }
        }
    }
}

