/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class IndexKeyBuilder {
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public void delimiter() {
        this.buf.write(0);
        this.buf.write(1);
    }

    public void infinity() {
        this.buf.write(255);
        this.buf.write(255);
    }

    public void nul() {
        this.buf.write(0);
    }

    public void add(byte[] bin, int pos, int cnt) {
        while (0 < cnt--) {
            byte b;
            if ((b = bin[pos++]) == 0) {
                this.buf.write(0);
                this.buf.write(255);
                continue;
            }
            if (b == -1) {
                this.buf.write(255);
                this.buf.write(0);
                continue;
            }
            this.buf.write(b);
        }
    }

    public void desc(byte[] bin, int pos, int cnt) {
        while (0 < cnt--) {
            int b;
            if ((b = 255 - (bin[pos++] & 0xFF)) == 0) {
                this.buf.write(0);
                this.buf.write(255);
                continue;
            }
            if (b == 255) {
                this.buf.write(255);
                this.buf.write(0);
                continue;
            }
            this.buf.write(b);
        }
    }

    public void add(byte[] bin) {
        this.add(bin, 0, bin.length);
    }

    public void desc(byte[] bin) {
        this.desc(bin, 0, bin.length);
    }

    public void add(String str) {
        try {
            this.add(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM does not support UTF-8", e);
        }
    }

    public void desc(String str) {
        try {
            this.desc(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM does not support UTF-8", e);
        }
    }

    public void add(char ch) {
        if (ch == '\u0000') {
            this.buf.write(0);
            this.buf.write(255);
        } else if (ch <= '\u00ff') {
            this.buf.write(ch);
        } else {
            this.add(Character.toString(ch));
        }
    }

    public void desc(char ch) {
        this.desc(Character.toString(ch));
    }

    public void add(long val) {
        byte[] t = new byte[9];
        int i = t.length;
        while (val != 0L) {
            t[--i] = (byte)(val & 0xFFL);
            val >>>= 8;
        }
        t[i - 1] = (byte)(t.length - i);
        this.buf.write(t, i - 1, t.length - i + 1);
    }

    public void desc(long val) {
        this.add(val ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void addRaw(byte[] bin) {
        this.buf.write(bin, 0, bin.length);
    }

    public byte[] toByteArray() {
        return this.buf.toByteArray();
    }
}

