/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql.generic;

import com.google.gwtorm.nosql.CounterShard;
import com.google.gwtorm.nosql.IndexKeyBuilder;
import com.google.gwtorm.nosql.IndexRow;
import com.google.gwtorm.nosql.NoSqlSchema;
import com.google.gwtorm.nosql.generic.GenericDatabase;
import com.google.gwtorm.nosql.generic.Row;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class GenericSchema
extends NoSqlSchema {
    private final GenericDatabase<?, ?, ?> db;

    protected GenericSchema(GenericDatabase<?, ?, ?> d) {
        super(d);
        this.db = d;
    }

    public void flush() throws OrmException {
    }

    public GenericDatabase<?, ?, ?> getDatabase() {
        return this.db;
    }

    @Override
    protected long nextLong(final String poolName) throws OrmException {
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(".sequence." + poolName);
        b.delimiter();
        try {
            final long[] res = new long[1];
            this.atomicUpdate(b.toByteArray(), new AtomicUpdate<byte[]>(){

                @Override
                public byte[] update(byte[] val) {
                    CounterShard ctr;
                    if (val != null) {
                        ctr = CounterShard.CODEC.decode(val);
                    } else {
                        long start = 1L;
                        for (SequenceModel s : GenericSchema.this.getDatabase().getSchemaModel().getSequences()) {
                            if (!poolName.equals(s.getSequenceName())) continue;
                            start = s.getSequence().startWith();
                            if (start != 0L) break;
                            start = 1L;
                            break;
                        }
                        ctr = new CounterShard(start, Long.MAX_VALUE);
                    }
                    if (ctr.isEmpty()) {
                        throw new NoMoreValues();
                    }
                    res[0] = ctr.next();
                    return CounterShard.CODEC.encodeToByteString(ctr).toByteArray();
                }
            });
            return res[0];
        }
        catch (NoMoreValues err) {
            throw new OrmException("Counter '" + poolName + "' out of values");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] fetchRow(byte[] key) throws OrmDuplicateKeyException, OrmException {
        byte[] fromKey = key;
        byte[] toKey = new byte[key.length + 1];
        System.arraycopy(key, 0, toKey, 0, key.length);
        try (ResultSet<Row> r = this.scan(fromKey, toKey, 2, false);){
            Iterator<Row> i = r.iterator();
            if (!i.hasNext()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] data = i.next().getValue();
            if (i.hasNext()) {
                throw new OrmDuplicateKeyException("Unexpected duplicate keys");
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    public ResultSet<Row> fetchRows(Iterable<byte[]> keys) throws OrmException {
        ArrayList<Row> r = new ArrayList<Row>();
        for (byte[] key : keys) {
            byte[] val = this.fetchRow(key);
            if (val == null) continue;
            r.add(new Row(key, val));
        }
        return new ListResultSet<Row>(r);
    }

    public abstract ResultSet<Row> scan(byte[] var1, byte[] var2, int var3, boolean var4) throws OrmException;

    public void insert(byte[] key, final byte[] newData) throws OrmDuplicateKeyException, OrmException {
        try {
            this.atomicUpdate(key, new AtomicUpdate<byte[]>(){

                @Override
                public byte[] update(byte[] oldData) {
                    if (oldData != null) {
                        throw new KeyExists();
                    }
                    return newData;
                }
            });
        }
        catch (KeyExists err) {
            throw new OrmDuplicateKeyException("Duplicate key");
        }
    }

    public abstract void upsert(byte[] var1, byte[] var2) throws OrmException;

    public abstract void delete(byte[] var1) throws OrmException;

    public abstract void atomicUpdate(byte[] var1, AtomicUpdate<byte[]> var2) throws OrmException;

    public void maybeFossilCollectIndexRow(long now, byte[] key, IndexRow row) {
        if (row.getTimestamp() + this.db.getMaxFossilAge() <= now) {
            this.fossilCollectIndexRow(key, row);
        }
    }

    protected void fossilCollectIndexRow(byte[] key, IndexRow row) {
        try {
            this.delete(key);
        }
        catch (OrmException ormException) {
            // empty catch block
        }
    }

    private static class NoMoreValues
    extends RuntimeException {
        private NoMoreValues() {
        }
    }

    private static class KeyExists
    extends RuntimeException {
        private KeyExists() {
        }
    }
}

