/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql.heap;

import com.google.gwtorm.nosql.heap.TreeMapAccess;
import com.google.gwtorm.nosql.heap.TreeMapDatabase;
import com.google.gwtorm.nosql.heap.TreeMapSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;

public class FileDatabase<T extends Schema>
extends TreeMapDatabase<T, LoggingSchema, LoggingAccess> {
    private static final int MAX_LOG_SIZE = 50000;
    private final File heapFile;
    private final File logFile;
    private RandomAccessFile log;
    private int logRecords;

    public FileDatabase(File path, Class<T> schema) throws OrmException {
        super(LoggingSchema.class, LoggingAccess.class, schema);
        this.heapFile = new File(path.getAbsolutePath() + ".nosql_db");
        this.logFile = new File(path.getAbsolutePath() + ".nosql_log");
        this.lock.lock();
        try {
            this.loadHeap();
            this.loadLog();
        }
        catch (IOException err) {
            throw new OrmException("Cannot load existing database", err);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws OrmException {
        block8: {
            this.lock.lock();
            try {
                if (this.log == null) break block8;
                try {
                    this.log.close();
                }
                catch (IOException err) {
                    throw new OrmException("Cannot close log file", err);
                }
                finally {
                    this.log = null;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHeap() throws IOException {
        this.lock.lock();
        try {
            DataInputStream in;
            this.table.clear();
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.heapFile)));
            }
            catch (FileNotFoundException e) {
                this.lock.unlock();
                return;
            }
            try {
                int cnt = in.readInt();
                for (int row = 0; row < cnt; ++row) {
                    byte[] key = new byte[in.readInt()];
                    byte[] val = new byte[in.readInt()];
                    in.readFully(key);
                    in.readFully(val);
                    this.table.put(key, val);
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLog() throws IOException, OrmException {
        this.lock.lock();
        try {
            DataInputStream in;
            this.logRecords = 0;
            try {
                in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.logFile)));
            }
            catch (FileNotFoundException e) {
                this.lock.unlock();
                return;
            }
            try {
                int op;
                while ((op = in.read()) >= 0) {
                    switch (op) {
                        case 0: {
                            byte[] key = new byte[in.readInt()];
                            in.readFully(key);
                            this.table.remove(key);
                            break;
                        }
                        case 1: {
                            byte[] key = new byte[in.readInt()];
                            byte[] val = new byte[in.readInt()];
                            in.readFully(key);
                            in.readFully(val);
                            this.table.put(key, val);
                            break;
                        }
                        default: {
                            throw new OrmException("Unknown log command " + op);
                        }
                    }
                    ++this.logRecords;
                }
            }
            finally {
                in.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeLog(int op, byte[] key, byte[] val) throws OrmException {
        if (this.logRecords == 50000) {
            this.compact();
            return;
        }
        try {
            this.openLog();
            int sz = 5 + key.length;
            if (op == 1) {
                sz += 4 + val.length;
            }
            ByteArrayOutputStream buf = new ByteArrayOutputStream(sz);
            DataOutputStream out = new DataOutputStream(buf);
            out.write(op);
            out.writeInt(key.length);
            if (op == 1) {
                out.writeInt(val.length);
            }
            out.write(key);
            if (op == 1) {
                out.write(val);
            }
            out.flush();
            this.log.write(buf.toByteArray());
            ++this.logRecords;
        }
        catch (IOException err) {
            throw new OrmException("Cannot log operation", err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact() throws OrmException {
        this.lock.lock();
        try {
            File tmp = this.newTempFile();
            boolean ok = false;
            try {
                try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));){
                    out.writeInt(this.table.size());
                    for (Map.Entry ent : this.table.entrySet()) {
                        out.writeInt(((byte[])ent.getKey()).length);
                        out.writeInt(((byte[])ent.getValue()).length);
                        out.write((byte[])ent.getKey());
                        out.write((byte[])ent.getValue());
                    }
                }
                if (!tmp.renameTo(this.heapFile)) {
                    throw new OrmException("Cannot replace " + this.heapFile);
                }
                ok = true;
                this.openLog();
                this.log.seek(0L);
                this.log.setLength(0L);
            }
            finally {
                if (!ok && !tmp.delete()) {
                    tmp.deleteOnExit();
                }
            }
        }
        catch (IOException err) {
            throw new OrmException("Cannot compact database", err);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void openLog() throws IOException {
        if (this.log == null) {
            this.log = new RandomAccessFile(this.logFile, "rws");
            this.log.seek(this.log.length());
        }
    }

    private File newTempFile() throws IOException {
        return File.createTempFile("heap_", "_db", this.heapFile.getParentFile());
    }

    public static abstract class LoggingAccess
    extends TreeMapAccess {
        protected LoggingAccess(LoggingSchema s) {
            super(s);
        }
    }

    public static abstract class LoggingSchema
    extends TreeMapSchema {
        private final FileDatabase<?> db;

        protected LoggingSchema(FileDatabase<?> db) {
            super((TreeMapDatabase<?, ?, ?>)db);
            this.db = db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void upsert(byte[] key, byte[] data) throws OrmException {
            this.db.lock.lock();
            try {
                super.upsert(key, data);
                ((FileDatabase)this.db).writeLog(1, key, data);
            }
            finally {
                this.db.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(byte[] key) throws OrmException {
            this.db.lock.lock();
            try {
                super.delete(key);
                ((FileDatabase)this.db).writeLog(0, key, null);
            }
            finally {
                this.db.lock.unlock();
            }
        }
    }
}

