/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.protobuf;

import com.google.gwtorm.protobuf.CodecGen;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public final class CodecFactory {
    private static final Map<Class<?>, String> encoders = Collections.synchronizedMap(new WeakHashMap());

    public static <T> ProtobufCodec<T> encoder(Class<T> type) throws IllegalStateException {
        GeneratedClassLoader loader = CodecFactory.newLoader(type);
        ProtobufCodec<T> encoder = null;
        String cacheName = encoders.get(type);
        if (cacheName != null) {
            encoder = CodecFactory.get(loader, cacheName);
        }
        if (encoder == null) {
            CodecGen<T> gen = new CodecGen<T>(loader, type);
            try {
                encoder = gen.create();
            }
            catch (OrmException e) {
                throw new IllegalArgumentException("Class " + type.getName() + " cannot be supported on protobuf", e);
            }
            encoders.put(type, encoder.getClass().getName());
        }
        return encoder;
    }

    private static <T> GeneratedClassLoader newLoader(Class<T> type) {
        return new GeneratedClassLoader(type.getClassLoader());
    }

    private static <T> ProtobufCodec<T> get(ClassLoader cl, String name) {
        try {
            return (ProtobufCodec)Class.forName(name, true, cl).newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private CodecFactory() {
    }
}

