/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema;

import com.google.gwtorm.schema.Util;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Sequence;

public class SequenceModel {
    protected String methodName;
    protected String name;
    protected Sequence sequence;
    protected Class<?> returnType;

    public SequenceModel(String method, Sequence seq, Class<?> type) throws OrmException {
        if (seq == null) {
            throw new OrmException("Method " + method + " is missing " + Sequence.class.getName() + " annotation");
        }
        if (type != Integer.TYPE && type != Long.TYPE) {
            throw new OrmException("Sequence method " + method + " must return int or long");
        }
        this.sequence = seq;
        this.methodName = method;
        String n = this.methodName.startsWith("next") ? this.methodName.substring(4) : this.methodName;
        this.name = Util.any(this.sequence.name(), Util.makeSqlFriendly(n));
        this.returnType = type;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSequenceName() {
        return this.name;
    }

    public Class<?> getResultType() {
        return this.returnType;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public String getCreateSequenceSql(SqlDialect dialect) {
        return dialect.getCreateSequenceSql(this);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Sequence[\n");
        r.append("  method: " + this.getMethodName() + "\n");
        r.append("  name:   " + this.getSequenceName() + "\n");
        r.append("]");
        return r.toString();
    }
}

