/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.common.collect.Ordering;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.RowVersion;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.OrmException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class JavaColumnModel
extends ColumnModel {
    private final Field field;
    private final String fieldName;
    private final Class<?> primitiveType;
    private final Type genericType;

    public static List<Field> getDeclaredFields(Class<?> in) {
        return JavaColumnModel.sort(Arrays.asList(in.getDeclaredFields()));
    }

    static List<Field> sort(List<Field> fields) {
        return new Ordering<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                Column a1 = f1.getAnnotation(Column.class);
                Column a2 = f2.getAnnotation(Column.class);
                if (a1 == null && a2 == null) {
                    return f1.getName().compareTo(f2.getName());
                }
                if (a1 == null) {
                    return 1;
                }
                if (a2 == null) {
                    return -1;
                }
                return a1.id() - a2.id();
            }
        }.sortedCopy(fields);
    }

    public JavaColumnModel(Field f) throws OrmException {
        this.field = f;
        this.fieldName = this.field.getName();
        this.primitiveType = this.field.getType();
        this.genericType = this.field.getGenericType();
        this.initName(this.fieldName, this.field.getAnnotation(Column.class));
        if (Modifier.isPrivate(this.field.getModifiers())) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must not be private");
        }
        if (Modifier.isFinal(this.field.getModifiers())) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must not be final");
        }
        boolean bl = this.rowVersion = this.field.getAnnotation(RowVersion.class) != null;
        if (this.rowVersion && this.field.getType() != Integer.TYPE) {
            throw new OrmException("Field " + this.field.getName() + " of " + this.field.getDeclaringClass().getName() + " must have type 'int'");
        }
        this.initNested();
    }

    public JavaColumnModel(Field f, String fieldPath, int columnId, Class<?> columnType) throws OrmException {
        this.field = f;
        this.fieldName = fieldPath;
        this.columnName = fieldPath;
        this.columnId = columnId;
        this.primitiveType = columnType;
        this.genericType = null;
        this.initNested();
    }

    private void initNested() throws OrmException {
        if (this.isNested()) {
            ArrayList<JavaColumnModel> col = new ArrayList<JavaColumnModel>();
            for (Class<?> in = this.primitiveType; in != null; in = in.getSuperclass()) {
                for (Field f : JavaColumnModel.getDeclaredFields(in)) {
                    if (f.getAnnotation(Column.class) == null) continue;
                    col.add(new JavaColumnModel(f));
                }
            }
            this.initNestedColumns(col);
        }
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Class<?> getPrimitiveType() {
        return this.isPrimitive() ? this.primitiveType : null;
    }

    @Override
    public Type[] getArgumentTypes() {
        if (this.genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)this.genericType;
            return pt.getActualTypeArguments();
        }
        return new Type[0];
    }

    @Override
    public String getNestedClassName() {
        return this.isPrimitive() ? null : this.primitiveType.getName();
    }

    @Override
    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.primitiveType);
    }

    public Class<?> getNestedClass() {
        return this.primitiveType;
    }

    public Field getField() {
        return this.field;
    }

    private boolean isPrimitive() {
        return Util.isSqlPrimitive(this.primitiveType);
    }
}

