/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.java.JavaRelationModel;
import com.google.gwtorm.schema.java.ProtoFileGenerator;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Relation;
import com.google.gwtorm.server.Schema;
import com.google.gwtorm.server.Sequence;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class JavaSchemaModel
extends SchemaModel {
    private final Class<?> schema;

    public JavaSchemaModel(Class<?> schemaInterface) throws OrmException {
        this.schema = schemaInterface;
        if (!this.schema.isInterface()) {
            throw new OrmException("Schema " + this.schema.getName() + " must be an interface");
        }
        if (this.schema.getInterfaces().length != 1 || this.schema.getInterfaces()[0] != Schema.class) {
            throw new OrmException("Schema " + this.schema.getName() + " must only extend " + Schema.class.getName());
        }
        for (Method m : this.schema.getDeclaredMethods()) {
            if (m.getAnnotation(Relation.class) != null) {
                this.add(new JavaRelationModel(m));
                continue;
            }
            Sequence seq = m.getAnnotation(Sequence.class);
            if (seq == null) continue;
            this.add(new SequenceModel(m.getName(), seq, m.getReturnType()));
        }
    }

    public RelationModel getRelation(String name) {
        for (RelationModel m : this.getRelations()) {
            if (!m.getMethodName().equals(name)) continue;
            return m;
        }
        throw new IllegalArgumentException("No relation named " + name);
    }

    public void generateProto(PrintWriter out) {
        ProtoFileGenerator pfg = new ProtoFileGenerator(this.schema.getSimpleName(), this.getRelations());
        pfg.print(out);
    }

    @Override
    public String getSchemaClassName() {
        return this.schema.getName();
    }
}

