/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.java;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.Util;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Type;

class ProtoFileGenerator {
    private static final Comparator<ColumnModel> COLUMN_COMPARATOR = new Comparator<ColumnModel>(){

        @Override
        public int compare(ColumnModel o1, ColumnModel o2) {
            return o1.getColumnID() - o2.getColumnID();
        }
    };
    private static final Comparator<RelationModel> RELATION_COMPARATOR = new Comparator<RelationModel>(){

        @Override
        public int compare(RelationModel o1, RelationModel o2) {
            return o1.getRelationID() - o2.getRelationID();
        }
    };
    private final Collection<RelationModel> rels;
    private final String schemaName;
    private final HashSet<String> seen;
    private final HashSet<String> collisions;

    ProtoFileGenerator(String schemaName, Collection<RelationModel> relations) {
        this.schemaName = schemaName;
        this.rels = relations;
        this.seen = new HashSet();
        this.collisions = new HashSet();
    }

    void print(PrintWriter out) {
        this.seen.clear();
        this.collisions.clear();
        for (RelationModel r : this.rels) {
            for (ColumnModel c : r.getColumns()) {
                if (!c.isNested()) continue;
                String type = ProtoFileGenerator.getShortClassName(c);
                if (this.seen.contains(type)) {
                    this.collisions.add(type);
                    continue;
                }
                this.seen.add(type);
            }
        }
        this.seen.clear();
        for (RelationModel r : this.rels) {
            this.generateMessage(r.getPrimaryKey().getField(), out, true);
        }
        for (RelationModel r : this.rels) {
            this.generateMessage(r, out);
        }
        out.print("message Any" + this.schemaName + "PrimaryKey {\n");
        for (RelationModel r : ProtoFileGenerator.sortRelations(this.rels)) {
            ColumnModel pk = r.getPrimaryKey().getField();
            out.print("\toptional " + this.getType(pk) + " " + r.getRelationName().toLowerCase() + " = " + r.getRelationID() + ";\n");
        }
        out.print("}\n");
        out.print("\n");
        out.print("message Any" + this.schemaName + " {\n");
        for (RelationModel r : ProtoFileGenerator.sortRelations(this.rels)) {
            out.print("\toptional " + ProtoFileGenerator.getMessageName(r) + " " + r.getRelationName().toLowerCase() + " = " + r.getRelationID() + ";\n");
        }
        out.print("}\n");
    }

    private void generateMessage(RelationModel rel, PrintWriter out) {
        List<ColumnModel> cols = ProtoFileGenerator.sortColumns(rel.getFields());
        for (ColumnModel c : cols) {
            this.generateMessage(c, out, false);
        }
        ColumnModel pk = rel.getPrimaryKey().getField();
        out.print("message " + ProtoFileGenerator.getMessageName(rel) + " {\n");
        for (ColumnModel c : cols) {
            out.append("\t");
            out.append(pk.equals(c) ? "required" : "optional");
            out.append(" ").append(this.getType(c)).append(" ");
            out.append(ProtoFileGenerator.getName(c));
            out.append(" = ").append(Integer.toString(c.getColumnID()));
            out.append(";\n");
        }
        out.print("}\n\n");
    }

    private void generateMessage(ColumnModel parent, PrintWriter out, boolean required) {
        if (!parent.isNested()) {
            return;
        }
        if (this.seen.contains(parent.getNestedClassName())) {
            return;
        }
        List<ColumnModel> children = ProtoFileGenerator.sortColumns(parent.getNestedColumns());
        for (ColumnModel child : children) {
            this.generateMessage(child, out, required);
        }
        out.print("message " + this.getType(parent) + " {\n");
        for (ColumnModel child : children) {
            out.append("\t");
            out.append(required ? "required" : "optional");
            out.append(" ").append(this.getType(child)).append(" ");
            out.append(Util.makeSqlFriendly(child.getFieldName()));
            out.append(" = ").append(Integer.toString(child.getColumnID()));
            out.append(";\n");
        }
        out.print("}\n\n");
        this.seen.add(parent.getNestedClassName());
    }

    private String getType(ColumnModel cm) {
        if (cm.isNested()) {
            String type = ProtoFileGenerator.getShortClassName(cm);
            if (this.collisions.contains(type)) {
                return cm.getNestedClassName().replace('.', '_').replace('$', '_');
            }
            return type;
        }
        return ProtoFileGenerator.toProtoType(cm.getPrimitiveType());
    }

    private static String getName(ColumnModel cm) {
        if (cm.getColumnName().equals("--NONE--")) {
            return cm.getFieldName();
        }
        return cm.getColumnName();
    }

    private static String getShortClassName(ColumnModel cm) {
        String tmp = cm.getNestedClassName();
        return tmp.substring(tmp.lastIndexOf(46) + 1).replace('$', '_');
    }

    private static String getMessageName(RelationModel r) {
        String typeName = r.getEntityTypeClassName();
        return typeName.substring(typeName.lastIndexOf(46) + 1);
    }

    private static List<ColumnModel> sortColumns(Collection<ColumnModel> cols) {
        ArrayList<ColumnModel> list = new ArrayList<ColumnModel>(cols);
        Collections.sort(list, COLUMN_COMPARATOR);
        return list;
    }

    private static List<RelationModel> sortRelations(Collection<RelationModel> rels) {
        ArrayList<RelationModel> list = new ArrayList<RelationModel>(rels);
        Collections.sort(list, RELATION_COMPARATOR);
        return list;
    }

    private static String toProtoType(Class<?> clazz) {
        switch (Type.getType(clazz).getSort()) {
            case 1: {
                return "bool";
            }
            case 2: {
                return "uint32";
            }
            case 3: 
            case 4: 
            case 5: {
                return "int32";
            }
            case 6: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 7: {
                return "int64";
            }
            case 9: 
            case 10: {
                if (clazz == byte[].class) {
                    return "bytes";
                }
                if (clazz == String.class) {
                    return "string";
                }
                if (clazz == Timestamp.class) {
                    return "fixed64";
                }
                throw new RuntimeException("Type " + clazz + " not supported on protobuf!");
            }
        }
        throw new RuntimeException("Type " + clazz + " not supported on protobuf!");
    }
}

