/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.StatementExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class DialectMaxDB
extends SqlDialect {
    public DialectMaxDB() {
        this.typeNames.put(-5, "FIXED (19,0)");
        this.typeNames.put(-1, "LONG UNICODE");
    }

    @Override
    public boolean canDetermineIndividualBatchUpdateCounts() {
        return false;
    }

    @Override
    public boolean canDetermineTotalBatchUpdateCount() {
        return true;
    }

    @Override
    public int executeBatch(PreparedStatement ps) throws SQLException {
        ps.executeBatch();
        return ps.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> listSequences(Connection conn) throws SQLException {
        try (Statement s = conn.createStatement();){
            HashSet<String> hashSet;
            ResultSet rs = s.executeQuery("SELECT sequence_name FROM sequences");
            try {
                HashSet<String> sequences = new HashSet<String>();
                while (rs.next()) {
                    sequences.add(rs.getString(1).toLowerCase());
                }
                hashSet = sequences;
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return hashSet;
        }
    }

    @Override
    public void renameColumn(StatementExecutor e, String tableName, String fromColumn, ColumnModel col) throws OrmException {
        StringBuilder s = new StringBuilder();
        s.append("RENAME COLUMN ");
        s.append(tableName).append(".").append(fromColumn);
        s.append(" TO ");
        s.append(col.getColumnName());
        e.execute(s.toString());
    }

    @Override
    public OrmException convertError(String op, String entity, SQLException err) {
        int errorCode;
        int sqlstate = DialectMaxDB.getSQLStateInt(err);
        if (sqlstate == 23000 && ((errorCode = err.getErrorCode()) == 200 || errorCode == -20)) {
            return new OrmDuplicateKeyException(entity, err);
        }
        return super.convertError(op, entity, err);
    }

    @Override
    public String getNextSequenceValueSql(String seqname) {
        return "SELECT " + seqname + ".nextval FROM dual";
    }

    @Override
    public boolean handles(String url, Connection c) throws SQLException {
        return url.startsWith("jdbc:sapdb:");
    }

    @Override
    public void renameTable(StatementExecutor e, String from, String to) throws OrmException {
        StringBuilder r = new StringBuilder();
        r.append("RENAME TABLE ");
        r.append(from);
        r.append(" TO ");
        r.append(to);
        e.execute(r.toString());
    }
}

