/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.server;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.server.Access;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmConcurrencyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAccess<E, K extends Key<?>>
implements Access<E, K> {
    private static final int MAX_TRIES = 10;

    @Override
    public void beginTransaction(K key) throws OrmException {
    }

    @Override
    public CheckedFuture<E, OrmException> getAsync(K key) {
        try {
            return Futures.immediateCheckedFuture(this.get(key));
        }
        catch (OrmException e) {
            return Futures.immediateFailedCheckedFuture(e);
        }
    }

    @Override
    public ResultSet<E> get(Iterable<K> keys) throws OrmException {
        ArrayList r = new ArrayList();
        for (Key key : keys) {
            Object o = this.get(key);
            if (o == null) continue;
            r.add(o);
        }
        return new ListResultSet(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, E> toMap(Iterable<E> c) {
        try {
            HashMap r = new HashMap();
            for (E e : c) {
                r.put(this.primaryKey(e), e);
            }
            HashMap hashMap = r;
            return hashMap;
        }
        finally {
            if (c instanceof ResultSet) {
                ((ResultSet)c).close();
            }
        }
    }

    @Override
    public E atomicUpdate(K key, AtomicUpdate<E> update) throws OrmException {
        int attempts = 1;
        while (true) {
            try {
                Object obj = this.get(key);
                if (obj == null) {
                    return null;
                }
                E res = update.update(obj);
                this.update(Collections.singleton(obj));
                return res;
            }
            catch (OrmConcurrencyException err) {
                if (attempts >= 10) {
                    throw err;
                }
                ++attempts;
                continue;
            }
            break;
        }
    }

    @Override
    public void deleteKeys(Iterable<K> keys) throws OrmException {
        this.delete(this.get(keys));
    }
}

