/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.server;

import com.google.gwtorm.schema.ColumnModel;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class CodeGenSupport
implements Opcodes {
    public final MethodVisitor mv;
    private ColumnModel col;
    private int dupOnSet;
    private int columnIdx;
    private Type entityType;
    private int lastLocal = 2;
    private List<Integer> freeLocals = new ArrayList<Integer>(4);

    public CodeGenSupport(MethodVisitor method) {
        this.mv = method;
    }

    public void push(int val) {
        switch (val) {
            case -1: {
                this.mv.visitInsn(2);
                break;
            }
            case 0: {
                this.mv.visitInsn(3);
                break;
            }
            case 1: {
                this.mv.visitInsn(4);
                break;
            }
            case 2: {
                this.mv.visitInsn(5);
                break;
            }
            case 3: {
                this.mv.visitInsn(6);
                break;
            }
            case 4: {
                this.mv.visitInsn(7);
                break;
            }
            case 5: {
                this.mv.visitInsn(8);
                break;
            }
            default: {
                if (-128 >= val && val < 127) {
                    this.mv.visitIntInsn(16, val);
                    break;
                }
                if (Short.MIN_VALUE >= val && val < Short.MAX_VALUE) {
                    this.mv.visitIntInsn(17, val);
                    break;
                }
                this.mv.visitLdcInsn(val);
            }
        }
    }

    public void loadVar(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(21), index);
    }

    public int newLocal() {
        if (this.freeLocals.isEmpty()) {
            return ++this.lastLocal;
        }
        return this.freeLocals.remove(this.freeLocals.size() - 1);
    }

    public void freeLocal(int index) {
        this.freeLocals.add(index);
    }

    public void setEntityType(Type et) {
        this.entityType = et;
    }

    public void setFieldReference(ColumnModel cm) {
        this.col = cm;
        this.dupOnSet = -1;
        ++this.columnIdx;
    }

    public void resetColumnIndex(int s) {
        this.columnIdx = s;
    }

    public int getColumnIndex() {
        return this.columnIdx;
    }

    public ColumnModel getFieldReference() {
        return this.col;
    }

    public void pushSqlHandle() {
        this.mv.visitVarInsn(25, 1);
    }

    public void pushEntity() {
        this.mv.visitVarInsn(25, 2);
    }

    public void pushColumnIndex() {
        this.push(this.columnIdx);
    }

    public void invokePreparedStatementSet(String sqlTypeName) {
        Method m;
        try {
            m = PreparedStatement.class.getMethod("set" + sqlTypeName, Integer.TYPE, ResultSet.class.getMethod("get" + sqlTypeName, Integer.TYPE).getReturnType());
        }
        catch (SecurityException e) {
            throw new RuntimeException("java.sql has no " + sqlTypeName);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("java.sql has no " + sqlTypeName, e);
        }
        this.mv.visitMethodInsn(185, Type.getInternalName(PreparedStatement.class), m.getName(), Type.getMethodDescriptor(m));
    }

    public void invokeResultSetGet(String sqlTypeName) {
        Method m;
        try {
            m = ResultSet.class.getMethod("get" + sqlTypeName, Integer.TYPE);
        }
        catch (SecurityException e) {
            throw new RuntimeException("java.sql has no " + sqlTypeName);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("java.sql has no " + sqlTypeName, e);
        }
        this.mv.visitMethodInsn(185, Type.getInternalName(ResultSet.class), m.getName(), Type.getMethodDescriptor(m));
    }

    public void fieldSetBegin() {
        this.pushEntity();
        if (this.col.getParent() != null) {
            this.appendGetField(this.col.getParent());
        }
    }

    public void fieldSetEnd() {
        Type c = this.containerClass(this.col);
        if (this.dupOnSet >= 0) {
            this.mv.visitInsn(89);
            this.mv.visitVarInsn(58, this.dupOnSet);
        }
        this.mv.visitFieldInsn(181, c.getInternalName(), this.col.getFieldName(), CodeGenSupport.toType(this.col).getDescriptor());
    }

    public void setDupOnFieldSetEnd(int varIdx) {
        this.dupOnSet = varIdx;
    }

    public void pushFieldValue() {
        this.pushEntity();
        this.appendGetField(this.col);
    }

    protected void appendGetField(ColumnModel c) {
        if (c.getParent() != null) {
            this.appendGetField(c.getParent());
        }
        Type t = this.containerClass(c);
        this.mv.visitFieldInsn(180, t.getInternalName(), c.getFieldName(), CodeGenSupport.toType(c).getDescriptor());
    }

    private Type containerClass(ColumnModel c) {
        if (c.getParent() == null) {
            return this.entityType;
        }
        String n = c.getParent().getNestedClassName();
        return Type.getObjectType(n.replace('.', '/'));
    }

    public static Type toType(ColumnModel c) {
        if (c.isSqlPrimitive()) {
            return Type.getType(c.getPrimitiveType());
        }
        return Type.getObjectType(c.getNestedClassName().replace('.', '/'));
    }
}

