/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.server;

import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import com.google.gwtorm.server.SchemaFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class SchemaConstructorGen<T extends Schema>
implements Opcodes {
    private static final String CTX = "schemaArg";
    private final GeneratedClassLoader classLoader;
    private final Class<T> schemaImpl;
    private final Object schemaArg;
    private ClassWriter cw;
    private String implClassName;
    private String implTypeName;

    public SchemaConstructorGen(GeneratedClassLoader loader, Class<T> c, Object f) {
        this.classLoader = loader;
        this.schemaImpl = c;
        this.schemaArg = f;
    }

    public void defineClass() throws OrmException {
        this.init();
        this.declareFactoryField();
        this.implementConstructor();
        this.implementNewInstance();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.implClassName, this.cw.toByteArray());
    }

    public SchemaFactory<T> create() throws OrmException {
        this.defineClass();
        try {
            Class<?> c = Class.forName(this.implClassName, true, this.classLoader);
            Constructor<?> n = c.getDeclaredConstructors()[0];
            return this.cast(n.newInstance(this.schemaArg));
        }
        catch (InstantiationException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (IllegalAccessException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (ClassNotFoundException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (IllegalArgumentException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
        catch (InvocationTargetException e) {
            throw new OrmException("Cannot create schema factory", e);
        }
    }

    private SchemaFactory<T> cast(Object newInstance) {
        return (SchemaFactory)newInstance;
    }

    private void init() {
        this.implClassName = this.schemaImpl.getName() + "_Factory_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, Type.getInternalName(Object.class), new String[]{Type.getInternalName(SchemaFactory.class)});
    }

    private void declareFactoryField() {
        this.cw.visitField(18, CTX, Type.getType(this.schemaArg.getClass()).getDescriptor(), null, null).visitEnd();
    }

    private void implementConstructor() {
        Type ft = Type.getType(this.schemaArg.getClass());
        String consName = "<init>";
        String consDesc = Type.getMethodDescriptor(Type.VOID_TYPE, ft);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", consDesc, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.implTypeName, CTX, ft.getDescriptor());
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementNewInstance() {
        Type ft = Type.getType(this.schemaArg.getClass());
        String typeName = Type.getType(this.schemaImpl).getInternalName();
        MethodVisitor mv = this.cw.visitMethod(17, "open", Type.getMethodDescriptor(Type.getType(Schema.class), new Type[0]), null, null);
        mv.visitCode();
        Constructor<?> c = this.schemaImpl.getDeclaredConstructors()[0];
        Type argType = Type.getType(c.getParameterTypes()[0]);
        mv.visitTypeInsn(187, typeName);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.implTypeName, CTX, ft.getDescriptor());
        mv.visitMethodInsn(183, typeName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, argType));
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }
}

