/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.server;

import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.SequenceModel;
import com.google.gwtorm.schema.Util;
import com.google.gwtorm.server.AbstractSchema;
import com.google.gwtorm.server.Access;
import com.google.gwtorm.server.CodeGenSupport;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class SchemaGen<S extends AbstractSchema>
implements Opcodes {
    private final GeneratedClassLoader classLoader;
    private final SchemaModel schema;
    private final Class<?> databaseClass;
    private final Class<S> schemaSuperClass;
    private final AccessGenerator accessGen;
    private List<RelationGen> relations;
    private ClassWriter cw;
    private String implClassName;
    private String implTypeName;

    public SchemaGen(GeneratedClassLoader loader, SchemaModel schemaModel, Class<?> databaseType, Class<S> superType, AccessGenerator ag) {
        this.classLoader = loader;
        this.schema = schemaModel;
        this.databaseClass = databaseType;
        this.schemaSuperClass = superType;
        this.accessGen = ag;
    }

    public Class<Schema> create() throws OrmException {
        this.defineRelationClasses();
        this.init();
        this.implementRelationFields();
        this.implementConstructor();
        this.implementSequenceMethods();
        this.implementRelationMethods();
        this.implementAllRelationsMethod();
        this.cw.visitEnd();
        this.classLoader.defineClass(this.getImplClassName(), this.cw.toByteArray());
        return this.loadClass();
    }

    private Class<Schema> loadClass() throws OrmException {
        try {
            Class<Schema> c = Class.forName(this.getImplClassName(), false, this.classLoader);
            return c;
        }
        catch (ClassNotFoundException err) {
            throw new OrmException("Cannot load generated class", err);
        }
    }

    String getSchemaClassName() {
        return this.schema.getSchemaClassName();
    }

    String getImplClassName() {
        return this.implClassName;
    }

    String getImplTypeName() {
        return this.implTypeName;
    }

    private void defineRelationClasses() throws OrmException {
        this.relations = new ArrayList<RelationGen>();
        for (RelationModel rel : this.schema.getRelations()) {
            Class<?> a = this.accessGen.create(this.classLoader, rel);
            this.relations.add(new RelationGen(rel, a));
        }
        Collections.sort(this.relations, new Comparator<RelationGen>(){

            @Override
            public int compare(RelationGen a, RelationGen b) {
                int cmp = a.model.getRelationID() - b.model.getRelationID();
                if (cmp == 0) {
                    cmp = a.model.getRelationName().compareTo(b.model.getRelationName());
                }
                return cmp;
            }
        });
    }

    private void init() {
        this.implClassName = this.getSchemaClassName() + "_Schema_" + Util.createRandomName();
        this.implTypeName = this.implClassName.replace('.', '/');
        this.cw = new ClassWriter(1);
        this.cw.visit(47, 49, this.implTypeName, null, Type.getInternalName(this.schemaSuperClass), new String[]{this.getSchemaClassName().replace('.', '/')});
    }

    private void implementRelationFields() {
        for (RelationGen info : this.relations) {
            info.implementField();
        }
    }

    private void implementConstructor() {
        String consName = "<init>";
        Type superType = Type.getType(this.schemaSuperClass);
        Type dbType = Type.getType(this.databaseClass);
        MethodVisitor mv = this.cw.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, dbType), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, superType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, Type.getType(this.schemaSuperClass.getDeclaredConstructors()[0].getParameterTypes()[0])));
        for (RelationGen info : this.relations) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, info.accessType.getInternalName());
            mv.visitInsn(89);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, info.accessType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, superType));
            mv.visitFieldInsn(181, this.implTypeName, info.getAccessInstanceFieldName(), info.accessType.getDescriptor());
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void implementSequenceMethods() {
        for (SequenceModel seq : this.schema.getSequences()) {
            Type retType = Type.getType(seq.getResultType());
            MethodVisitor mv = this.cw.visitMethod(1, seq.getMethodName(), Type.getMethodDescriptor(retType, new Type[0]), null, new String[]{Type.getType(OrmException.class).getInternalName()});
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn(seq.getSequenceName());
            mv.visitMethodInsn(182, Type.getInternalName(this.schemaSuperClass), "nextLong", Type.getMethodDescriptor(Type.getType(Long.TYPE), Type.getType(String.class)));
            if (retType.getSize() == 1) {
                mv.visitInsn(136);
                mv.visitInsn(172);
            } else {
                mv.visitInsn(173);
            }
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }
    }

    private void implementRelationMethods() {
        for (RelationGen info : this.relations) {
            info.implementMethod();
        }
    }

    private void implementAllRelationsMethod() {
        MethodVisitor mv = this.cw.visitMethod(17, "allRelations", Type.getMethodDescriptor(Type.getType(Access[].class), new Type[0]), null, null);
        mv.visitCode();
        boolean r = true;
        CodeGenSupport cgs = new CodeGenSupport(mv);
        cgs.push(this.relations.size());
        mv.visitTypeInsn(189, Type.getType(Access.class).getInternalName());
        mv.visitVarInsn(58, 1);
        int index = 0;
        for (RelationGen info : this.relations) {
            mv.visitVarInsn(25, 1);
            cgs.push(index++);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, this.getImplTypeName(), info.model.getMethodName(), info.getDescriptor());
            mv.visitInsn(83);
        }
        mv.visitVarInsn(25, 1);
        mv.visitInsn(176);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private class RelationGen {
        final RelationModel model;
        final Type accessType;

        RelationGen(RelationModel model, Class<?> accessClass) {
            this.model = model;
            this.accessType = Type.getType(accessClass);
        }

        void implementField() {
            SchemaGen.this.cw.visitField(18, this.getAccessInstanceFieldName(), this.accessType.getDescriptor(), null, null).visitEnd();
        }

        String getAccessInstanceFieldName() {
            return "access_" + this.model.getMethodName();
        }

        void implementMethod() {
            MethodVisitor mv = SchemaGen.this.cw.visitMethod(17, this.model.getMethodName(), this.getDescriptor(), null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, SchemaGen.this.implTypeName, this.getAccessInstanceFieldName(), this.accessType.getDescriptor());
            mv.visitInsn(176);
            mv.visitMaxs(-1, -1);
            mv.visitEnd();
        }

        String getDescriptor() {
            return Type.getMethodDescriptor(Type.getObjectType(this.model.getAccessInterfaceName().replace('.', '/')), new Type[0]);
        }
    }

    public static interface AccessGenerator {
        public Class<?> create(GeneratedClassLoader var1, RelationModel var2) throws OrmException;
    }
}

