/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

class PRED_$get_prolog_impl_flag_2
extends Predicate.P2 {
    private static final SymbolTerm TRUE = SymbolTerm.intern("true");
    private static final SymbolTerm FALSE = SymbolTerm.intern("false");
    private static final SymbolTerm BOUNDED = SymbolTerm.intern("bounded");
    private static final SymbolTerm MAX_INTEGER = SymbolTerm.intern("max_integer");
    private static final SymbolTerm MIN_INTEGER = SymbolTerm.intern("min_integer");
    private static final SymbolTerm INTEGER_ROUNDING_FUNCTION = SymbolTerm.intern("integer_rounding_function");
    private static final SymbolTerm CHAR_CONVERSION = SymbolTerm.intern("char_conversion");
    private static final SymbolTerm DEBUG = SymbolTerm.intern("debug");
    private static final SymbolTerm MAX_ARITY = SymbolTerm.intern("max_arity");
    private static final SymbolTerm UNKNOWN = SymbolTerm.intern("unknown");
    private static final SymbolTerm DOUBLE_QUOTES = SymbolTerm.intern("double_quotes");
    private static final SymbolTerm PRINT_STACK_TRACE = SymbolTerm.intern("print_stack_trace");

    public PRED_$get_prolog_impl_flag_2(Term term, Term term2, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        prolog.setB0();
        Term term = this.arg1;
        Term term2 = this.arg2;
        term = term.dereference();
        term2 = term2.dereference();
        if (term.equals(BOUNDED)) {
            if (prolog.isBounded() ? !term2.unify(TRUE, prolog.trail) : !term2.unify(FALSE, prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(MAX_INTEGER)) {
            if (!term2.unify(new IntegerTerm(prolog.getMaxInteger()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(MIN_INTEGER)) {
            if (!term2.unify(new IntegerTerm(prolog.getMinInteger()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(INTEGER_ROUNDING_FUNCTION)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getIntegerRoundingFunction()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(CHAR_CONVERSION)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getCharConversion()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(DEBUG)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getDebug()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(MAX_ARITY)) {
            if (!term2.unify(new IntegerTerm(prolog.getMaxArity()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(UNKNOWN)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getUnknown()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(DOUBLE_QUOTES)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getDoubleQuotes()), prolog.trail)) {
                return prolog.fail();
            }
        } else if (term.equals(PRINT_STACK_TRACE)) {
            if (!term2.unify(SymbolTerm.intern(prolog.getPrintStackTrace()), prolog.trail)) {
                return prolog.fail();
            }
        } else {
            return prolog.fail();
        }
        return this.cont;
    }
}

