/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.compiler;

import com.googlecode.prolog_cafe.compiler.CompileException;
import com.googlecode.prolog_cafe.lang.BufferingPrologControl;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;

public class Compiler {
    private BufferingPrologControl pcl = new BufferingPrologControl();
    private EnumSet<Option> options;

    public Compiler() {
        this.pcl.setPrologClassLoader(new PrologClassLoader(Compiler.class.getClassLoader()));
        this.options = EnumSet.noneOf(Option.class);
        this.enableDefaultOptions();
    }

    public void prologToWAM(String string, String string2) throws CompileException {
        if (!Compiler.fileExists(string)) {
            throw new CompileException(new FileNotFoundException(string));
        }
        SymbolTerm symbolTerm = SymbolTerm.create(string);
        SymbolTerm symbolTerm2 = SymbolTerm.create(string2);
        Term term = Prolog.Nil;
        for (Option option : this.options) {
            term = new ListTerm(option.symbol, term);
        }
        ListTerm listTerm = new ListTerm(symbolTerm, new ListTerm(symbolTerm2, new ListTerm(term, Prolog.Nil)));
        try {
            if (!this.pcl.execute("com.googlecode.prolog_cafe.compiler.pl2am", "pl2am", listTerm)) {
                throw new CompileException("Unknown Error");
            }
        }
        catch (PrologException prologException) {
            throw new CompileException("Error compiling " + string, prologException);
        }
    }

    public void wamToJavaSource(String string, String string2) throws CompileException {
        if (!Compiler.fileExists(string)) {
            throw new CompileException(new FileNotFoundException(string));
        }
        if (!Compiler.fileExists(string2) && !new File(string2).mkdirs()) {
            throw new CompileException(new FileNotFoundException(string2));
        }
        SymbolTerm symbolTerm = SymbolTerm.create(string);
        SymbolTerm symbolTerm2 = SymbolTerm.create(string2);
        ListTerm listTerm = new ListTerm(symbolTerm, new ListTerm(symbolTerm2, Prolog.Nil));
        try {
            if (!this.pcl.execute("com.googlecode.prolog_cafe.compiler.am2j", "am2j", listTerm)) {
                throw new CompileException("Unknown Error");
            }
        }
        catch (PrologException prologException) {
            throw new CompileException("Error converting " + string, prologException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prologToJavaSource(String string, String string2) throws CompileException {
        File file;
        try {
            file = File.createTempFile("PrologCafe_", ".am");
        }
        catch (IOException iOException) {
            throw new CompileException("Cannot create temporary file", iOException);
        }
        try {
            this.prologToWAM(string, file.getPath());
            this.wamToJavaSource(file.getPath(), string2);
        }
        finally {
            if (!file.delete() && file.exists()) {
                file.deleteOnExit();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        Compiler compiler = new Compiler();
        String string = ".";
        String string2 = null;
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (n = 0; n < stringArray.length; ++n) {
            String string3 = stringArray[n];
            if (string3.equals("--")) {
                ++n;
                break;
            }
            if (string3.equals("-O")) {
                compiler.enableDefaultOptions();
                continue;
            }
            if (string3.equals("-O:none")) {
                compiler.options.clear();
                continue;
            }
            if (string3.startsWith("-O:")) {
                String string4 = string3.substring("-O:".length());
                object = Compiler.findOptionByName(string4);
                if (object == null) continue;
                compiler.enable((Option)((Object)object));
                continue;
            }
            if (string3.equals("-s")) {
                if (++n == stringArray.length) {
                    Compiler.usage();
                }
                string = stringArray[n];
                continue;
            }
            if (string3.equals("-am")) {
                if (++n == stringArray.length) {
                    Compiler.usage();
                }
                string2 = stringArray[n];
                continue;
            }
            if (string3.equals("-h") || string3.equals("--help") || string3.equals("-help")) {
                Compiler.usage();
                continue;
            }
            if (string3.equals("--show-stack-trace")) {
                bl = true;
                continue;
            }
            if (string3.startsWith("-")) {
                System.err.println("error: Unsupported flag '" + (String)string3 + "'");
                Compiler.usage();
                continue;
            }
            linkedList.add(string3);
        }
        if (n < stringArray.length) {
            linkedList.addAll(Arrays.asList(stringArray).subList(n, stringArray.length));
        }
        if (linkedList.isEmpty()) {
            Compiler.usage();
        }
        Compiler.banner();
        for (String string3 : linkedList) {
            System.err.println("Translating " + string3);
            try {
                if (string2 != null) {
                    object = string3.endsWith(".pl") ? string3.substring(0, string3.length() - 3) : string3;
                    File file = new File(new File(string2), (String)object + ".am");
                    file.getParentFile().mkdirs();
                    compiler.prologToWAM(string3, file.getPath());
                    compiler.wamToJavaSource(file.getPath(), string);
                    continue;
                }
                compiler.prologToJavaSource(string3, string);
            }
            catch (CompileException compileException) {
                if (bl) {
                    compileException.printStackTrace();
                } else {
                    System.err.println("error: " + compileException.getMessage());
                }
                System.exit(1);
            }
        }
    }

    private static Option findOptionByName(String string) {
        for (Option option : Option.values()) {
            if (option.toString().equalsIgnoreCase(string)) {
                return option;
            }
            if (!option.symbol.name().equalsIgnoreCase(string)) continue;
            return option;
        }
        System.err.println("error: Unsupported option '" + string + "'");
        System.exit(1);
        throw new RuntimeException("System.exit(1)");
    }

    private static void usage() {
        System.err.print("usage: ");
        System.err.print("java ");
        System.err.print(Compiler.class.getName());
        System.err.print(" [options]");
        System.err.print(" prolog_source...");
        System.err.println();
        Compiler.banner();
        String string = "  %-20s %s";
        System.err.format(string, "-s <directory>", "where to place generated source files");
        System.err.println();
        System.err.format(string, "-am <directory>", "save WAM intermediate files");
        System.err.println();
        System.err.format(string, "-O", "enable all optimizations");
        System.err.println();
        System.err.format(string, "-O:none", "disable all optimizations");
        System.err.println();
        System.err.println();
        System.err.format(string, "-h, --help", "display this message");
        System.err.println();
        System.err.format(string, "--show-stack-trace", "show Java stack trace on failure");
        System.err.println();
        System.exit(1);
    }

    private static void banner() {
        System.err.println("Prolog Cafe");
        System.err.println("Copyright(C) 1997-2009 M.Banbara and N.Tamura");
        System.err.println();
    }

    private static boolean fileExists(String string) {
        try {
            return new File(string).exists();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public boolean isEnabled(Option option) {
        return this.options.contains((Object)option);
    }

    public void enable(Option option) {
        this.options.add(option);
    }

    public void disable(Option option) {
        this.options.remove((Object)option);
    }

    public void setEnabled(Option option, boolean bl) {
        if (bl) {
            this.enable(option);
        } else {
            this.disable(option);
        }
    }

    private void enableDefaultOptions() {
        for (Option option : Option.values()) {
            if (!option.onByDefault) continue;
            this.options.add(option);
        }
    }

    public static enum Option {
        eliminateDisjunctions("ed", true),
        arithmeticCompilation("ac", true),
        inlineExpansion("ie", true),
        optimiseRecursiveCall("rc", true),
        switchOnHash("idx", true),
        generateClosure("clo", false);

        final SymbolTerm symbol;
        final boolean onByDefault;

        private Option(String string2, boolean bl) {
            this.symbol = SymbolTerm.intern(string2);
            this.onByDefault = bl;
        }
    }
}

