/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.compiler.am2j;

import com.googlecode.prolog_cafe.lang.Arithmetic;
import com.googlecode.prolog_cafe.lang.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.Term;

final class PRED_java_integer_1
extends Predicate.P1 {
    static final IntegerTerm si1 = new IntegerTerm(Integer.MIN_VALUE);
    static final IntegerTerm si2 = new IntegerTerm(Integer.MAX_VALUE);

    public PRED_java_integer_1(Term term, Operation operation) {
        this.arg1 = term;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        prolog.setB0();
        Term term = this.arg1;
        term = term.dereference();
        if (!term.isInteger()) {
            return prolog.fail();
        }
        try {
            if (si1.arithCompareTo(Arithmetic.evaluate(term)) > 0) {
                return prolog.fail();
            }
        }
        catch (BuiltinException builtinException) {
            builtinException.goal = this;
            throw builtinException;
        }
        try {
            if (Arithmetic.evaluate(term).arithCompareTo(si2) > 0) {
                return prolog.fail();
            }
        }
        catch (BuiltinException builtinException) {
            builtinException.goal = this;
            throw builtinException;
        }
        return this.cont;
    }
}

