/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.IllegalDomainException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.NumberTerm;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class Arithmetic {
    static final SymbolTerm SYM_RANDOM = SymbolTerm.intern("random");
    static final SymbolTerm SYM_PI = SymbolTerm.intern("pi");
    static final SymbolTerm SYM_E = SymbolTerm.intern("e");
    static final SymbolTerm SYM_ADD_1 = SymbolTerm.intern("+", 1);
    static final SymbolTerm SYM_NEGATE_1 = SymbolTerm.intern("-", 1);
    static final SymbolTerm SYM_ADD_2 = SymbolTerm.intern("+", 2);
    static final SymbolTerm SYM_SUBTRACT_2 = SymbolTerm.intern("-", 2);
    static final SymbolTerm SYM_MULTIPLY_2 = SymbolTerm.intern("*", 2);
    static final SymbolTerm SYM_DIVIDE_2 = SymbolTerm.intern("/", 2);
    static final SymbolTerm SYM_INTDIVIDE_2 = SymbolTerm.intern("//", 2);
    static final SymbolTerm SYM_MOD_2 = SymbolTerm.intern("mod", 2);
    static final SymbolTerm SYM_SHIFTLEFT_2 = SymbolTerm.intern("<<", 2);
    static final SymbolTerm SYM_SHIFTRIGHT_2 = SymbolTerm.intern(">>", 2);
    static final SymbolTerm SYM_NOT_1 = SymbolTerm.intern("\\", 1);
    static final SymbolTerm SYM_AND_2 = SymbolTerm.intern("/\\", 2);
    static final SymbolTerm SYM_OR_2 = SymbolTerm.intern("\\/", 2);
    static final SymbolTerm SYM_XOR_2 = SymbolTerm.intern("#", 2);
    static final SymbolTerm SYM_POW_2 = SymbolTerm.intern("**", 2);
    static final SymbolTerm SYM_ABS_1 = SymbolTerm.intern("abs", 1);
    static final SymbolTerm SYM_ACOS_1 = SymbolTerm.intern("acos", 1);
    static final SymbolTerm SYM_ASIN_1 = SymbolTerm.intern("asin", 1);
    static final SymbolTerm SYM_ATAN_1 = SymbolTerm.intern("atan", 1);
    static final SymbolTerm SYM_CEIL_1 = SymbolTerm.intern("ceiling", 1);
    static final SymbolTerm SYM_COS_1 = SymbolTerm.intern("cos", 1);
    static final SymbolTerm SYM_DEGREES_1 = SymbolTerm.intern("degrees", 1);
    static final SymbolTerm SYM_EXP_1 = SymbolTerm.intern("exp", 1);
    static final SymbolTerm SYM_FLOOR_1 = SymbolTerm.intern("floor", 1);
    static final SymbolTerm SYM_LOG_1 = SymbolTerm.intern("log", 1);
    static final SymbolTerm SYM_MAX_2 = SymbolTerm.intern("max", 2);
    static final SymbolTerm SYM_MIN_2 = SymbolTerm.intern("min", 2);
    static final SymbolTerm SYM_RADIANS_1 = SymbolTerm.intern("radians", 1);
    static final SymbolTerm SYM_RINT_1 = SymbolTerm.intern("rint", 1);
    static final SymbolTerm SYM_ROUND_1 = SymbolTerm.intern("round", 1);
    static final SymbolTerm SYM_SIN_1 = SymbolTerm.intern("sin", 1);
    static final SymbolTerm SYM_SQRT_1 = SymbolTerm.intern("sqrt", 1);
    static final SymbolTerm SYM_TAN_1 = SymbolTerm.intern("tan", 1);
    static final SymbolTerm SYM_REM_2 = SymbolTerm.intern("rem", 2);
    static final SymbolTerm SYM_SIGN_1 = SymbolTerm.intern("sign", 1);
    static final SymbolTerm SYM_FLOAT_1 = SymbolTerm.intern("float", 1);
    static final SymbolTerm SYM_INTPART_1 = SymbolTerm.intern("float_integer_part", 1);
    static final SymbolTerm SYM_FRACTPART_1 = SymbolTerm.intern("float_fractional_part", 1);
    static final SymbolTerm SYM_TRUNCATE_1 = SymbolTerm.intern("truncate", 1);

    public static NumberTerm evaluate(Term term) throws PInstantiationException, IllegalDomainException {
        Term term2 = term.dereference();
        if (term2.isVariable()) {
            throw new PInstantiationException();
        }
        if (term2.isInteger()) {
            return (IntegerTerm)term2;
        }
        if (term2.isDouble()) {
            return (DoubleTerm)term2;
        }
        if (term2.equals(SYM_RANDOM)) {
            return new DoubleTerm(Math.random());
        }
        if (term2.equals(SYM_PI)) {
            return new DoubleTerm(Math.PI);
        }
        if (term2.equals(SYM_E)) {
            return new DoubleTerm(Math.E);
        }
        if (term2.isList()) {
            return Arithmetic.evaluate(((ListTerm)term2).car());
        }
        if (!term2.isStructure()) {
            throw new IllegalDomainException("arithmetic expression", term2);
        }
        SymbolTerm symbolTerm = ((StructureTerm)term2).functor();
        Term[] termArray = ((StructureTerm)term2).args();
        if (symbolTerm.equals(SYM_ADD_1)) {
            return Arithmetic.evaluate(termArray[0]);
        }
        if (symbolTerm.equals(SYM_NEGATE_1)) {
            return Arithmetic.evaluate(termArray[0]).negate();
        }
        if (symbolTerm.equals(SYM_ADD_2)) {
            return Arithmetic.evaluate(termArray[0]).add(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_SUBTRACT_2)) {
            return Arithmetic.evaluate(termArray[0]).subtract(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_MULTIPLY_2)) {
            return Arithmetic.evaluate(termArray[0]).multiply(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_INTDIVIDE_2)) {
            return Arithmetic.evaluate(termArray[0]).intDivide(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_DIVIDE_2)) {
            return Arithmetic.evaluate(termArray[0]).divide(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_MOD_2)) {
            return Arithmetic.evaluate(termArray[0]).mod(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_REM_2)) {
            return Arithmetic.evaluate(termArray[0]).mod(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_AND_2)) {
            return Arithmetic.evaluate(termArray[0]).and(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_OR_2)) {
            return Arithmetic.evaluate(termArray[0]).or(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_XOR_2)) {
            return Arithmetic.evaluate(termArray[0]).xor(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_NOT_1)) {
            return Arithmetic.evaluate(termArray[0]).not();
        }
        if (symbolTerm.equals(SYM_SHIFTLEFT_2)) {
            return Arithmetic.evaluate(termArray[0]).shiftLeft(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_SHIFTRIGHT_2)) {
            return Arithmetic.evaluate(termArray[0]).shiftRight(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_ABS_1)) {
            return Arithmetic.evaluate(termArray[0]).abs();
        }
        if (symbolTerm.equals(SYM_MIN_2)) {
            return Arithmetic.evaluate(termArray[0]).min(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_MAX_2)) {
            return Arithmetic.evaluate(termArray[0]).max(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_RINT_1)) {
            return Arithmetic.evaluate(termArray[0]).rint();
        }
        if (symbolTerm.equals(SYM_ROUND_1)) {
            return Arithmetic.evaluate(termArray[0]).round();
        }
        if (symbolTerm.equals(SYM_FLOOR_1)) {
            return Arithmetic.evaluate(termArray[0]).floor();
        }
        if (symbolTerm.equals(SYM_CEIL_1)) {
            return Arithmetic.evaluate(termArray[0]).ceil();
        }
        if (symbolTerm.equals(SYM_SIN_1)) {
            return Arithmetic.evaluate(termArray[0]).sin();
        }
        if (symbolTerm.equals(SYM_COS_1)) {
            return Arithmetic.evaluate(termArray[0]).cos();
        }
        if (symbolTerm.equals(SYM_TAN_1)) {
            return Arithmetic.evaluate(termArray[0]).tan();
        }
        if (symbolTerm.equals(SYM_ASIN_1)) {
            return Arithmetic.evaluate(termArray[0]).asin();
        }
        if (symbolTerm.equals(SYM_ACOS_1)) {
            return Arithmetic.evaluate(termArray[0]).acos();
        }
        if (symbolTerm.equals(SYM_ATAN_1)) {
            return Arithmetic.evaluate(termArray[0]).atan();
        }
        if (symbolTerm.equals(SYM_SQRT_1)) {
            return Arithmetic.evaluate(termArray[0]).sqrt();
        }
        if (symbolTerm.equals(SYM_LOG_1)) {
            return Arithmetic.evaluate(termArray[0]).log();
        }
        if (symbolTerm.equals(SYM_EXP_1)) {
            return Arithmetic.evaluate(termArray[0]).exp();
        }
        if (symbolTerm.equals(SYM_POW_2)) {
            return Arithmetic.evaluate(termArray[0]).pow(Arithmetic.evaluate(termArray[1]));
        }
        if (symbolTerm.equals(SYM_DEGREES_1)) {
            return Arithmetic.evaluate(termArray[0]).toDegrees();
        }
        if (symbolTerm.equals(SYM_RADIANS_1)) {
            return Arithmetic.evaluate(termArray[0]).toRadians();
        }
        if (symbolTerm.equals(SYM_SIGN_1)) {
            return Arithmetic.evaluate(termArray[0]).signum();
        }
        if (symbolTerm.equals(SYM_FLOAT_1)) {
            return Arithmetic.evaluate(termArray[0]).toFloat();
        }
        if (symbolTerm.equals(SYM_INTPART_1)) {
            return Arithmetic.evaluate(termArray[0]).floatIntPart();
        }
        if (symbolTerm.equals(SYM_FRACTPART_1)) {
            return Arithmetic.evaluate(termArray[0]).floatFractPart();
        }
        if (symbolTerm.equals(SYM_TRUNCATE_1)) {
            return Arithmetic.evaluate(termArray[0]).truncate();
        }
        throw new IllegalDomainException("arithmetic expression", term2);
    }
}

