/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.ChoicePointFrame;
import com.googlecode.prolog_cafe.lang.ChoicePointStack;
import com.googlecode.prolog_cafe.lang.Failure;
import com.googlecode.prolog_cafe.lang.HashtableOfTerm;
import com.googlecode.prolog_cafe.lang.InternalDatabase;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PermissionException;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologControl;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.SystemException;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class Prolog {
    private static final SymbolTerm NONE = SymbolTerm.intern("$none");
    public PrologControl control;
    public Term areg1;
    public Term areg2;
    public Term areg3;
    public Term areg4;
    public Term areg5;
    public Term areg6;
    public Term areg7;
    public Term areg8;
    public Term[] aregs;
    private static final Term[] NO_REGISTERS = new Term[0];
    public Operation cont;
    public final ChoicePointStack stack;
    public final Trail trail;
    public int B0;
    public PrologClassLoader pcl;
    public InternalDatabase internalDB;
    protected long CPFTimeStamp;
    public int halt;
    protected boolean bounded = false;
    protected static final int maxInteger = Integer.MAX_VALUE;
    protected static final int minInteger = Integer.MIN_VALUE;
    protected String integerRoundingFunction = "down";
    protected String charConversion;
    protected String debug;
    protected int maxArity = 255;
    protected String unknown;
    protected String doubleQuotes;
    protected String printStackTrace;
    protected Term exception;
    protected long startRuntime;
    protected long previousRuntime;
    protected final IdentityHashMap<VariableTerm, VariableTerm> copyHash;
    public static final int PUSHBACK_SIZE = 3;
    protected transient PushbackReader userInput;
    protected transient PrintWriter userOutput;
    protected transient PrintWriter userError;
    protected transient PushbackReader currentInput;
    protected transient PrintWriter currentOutput;
    protected HashtableOfTerm streamManager;
    protected final HashtableOfTerm hashManager;
    public static final String BUILTIN = "com.googlecode.prolog_cafe.builtin";
    public static final SymbolTerm Nil = SymbolTerm.intern("[]");
    static final SymbolTerm SYM_MODE_1 = SymbolTerm.intern("mode", 1);
    static final SymbolTerm SYM_ALIAS_1 = SymbolTerm.intern("alias", 1);
    static final SymbolTerm SYM_TYPE_1 = SymbolTerm.intern("type", 1);
    static final SymbolTerm SYM_READ = SymbolTerm.intern("read");
    static final SymbolTerm SYM_APPEND = SymbolTerm.intern("append");
    static final SymbolTerm SYM_INPUT = SymbolTerm.intern("input");
    static final SymbolTerm SYM_OUTPUT = SymbolTerm.intern("output");
    static final SymbolTerm SYM_TEXT = SymbolTerm.intern("text");
    static final SymbolTerm SYM_USERINPUT = SymbolTerm.intern("user_input");
    static final SymbolTerm SYM_USEROUTPUT = SymbolTerm.intern("user_output");
    static final SymbolTerm SYM_USERERROR = SymbolTerm.intern("user_error");
    private static final PrintWriter NO_OUTPUT = new PrintWriter(new Writer(){

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            throw new IOException("Prolog.Feature.IO disabled");
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    });
    private static final PushbackReader NO_INPUT = new PushbackReader(new Reader(){

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            return -1;
        }

        @Override
        public void close() throws IOException {
        }
    });
    protected final EnumSet<Feature> features = EnumSet.allOf(Feature.class);

    Prolog(PrologControl prologControl) {
        this.control = prologControl;
        this.trail = new Trail();
        this.stack = new ChoicePointStack(this.trail);
        this.copyHash = new IdentityHashMap();
        this.hashManager = new HashtableOfTerm();
    }

    Prolog(PrologControl prologControl, PrologMachineCopy prologMachineCopy) {
        this.control = prologControl;
        this.trail = new Trail();
        this.stack = new ChoicePointStack(this.trail);
        this.copyHash = new IdentityHashMap();
        this.pcl = prologMachineCopy.pcl;
        this.hashManager = PrologMachineCopy.copyShallow(prologMachineCopy.hashManager);
        this.internalDB = new InternalDatabase(this, prologMachineCopy.internalDB, false);
    }

    private void initOnce() {
        this.aregs = 8 < this.maxArity ? new Term[this.maxArity - 8] : NO_REGISTERS;
        if (this.pcl == null) {
            this.pcl = new PrologClassLoader();
        }
        if (this.internalDB == null) {
            this.internalDB = new InternalDatabase();
        }
        this.streamManager = new HashtableOfTerm();
        if (this.features.contains((Object)Feature.IO)) {
            this.userInput = new PushbackReader(new BufferedReader(new InputStreamReader(System.in)), 3);
            this.userOutput = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)), true);
            this.userError = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(System.err)), true);
            this.streamManager.put(SYM_USERINPUT, new JavaObjectTerm(this.userInput));
            this.streamManager.put(new JavaObjectTerm(this.userInput), this.makeStreamProperty(SYM_READ, SYM_INPUT, SYM_USERINPUT, SYM_TEXT));
            this.streamManager.put(SYM_USEROUTPUT, new JavaObjectTerm(this.userOutput));
            this.streamManager.put(new JavaObjectTerm(this.userOutput), this.makeStreamProperty(SYM_APPEND, SYM_OUTPUT, SYM_USEROUTPUT, SYM_TEXT));
            this.streamManager.put(SYM_USERERROR, new JavaObjectTerm(this.userError));
            this.streamManager.put(new JavaObjectTerm(this.userError), this.makeStreamProperty(SYM_APPEND, SYM_OUTPUT, SYM_USERERROR, SYM_TEXT));
        } else {
            this.userInput = NO_INPUT;
            this.userError = this.userOutput = NO_OUTPUT;
        }
    }

    public void init() {
        if (this.aregs == null) {
            this.initOnce();
        }
        this.stack.init();
        this.trail.init();
        this.B0 = this.stack.top();
        this.CPFTimeStamp = Long.MIN_VALUE;
        ChoicePointFrame choicePointFrame = ChoicePointFrame.S0(null);
        choicePointFrame.b0 = this.B0;
        choicePointFrame.bp = Failure.FAILURE;
        choicePointFrame.tr = this.trail.top();
        choicePointFrame.timeStamp = ++this.CPFTimeStamp;
        this.stack.push(choicePointFrame);
        this.halt = 0;
        this.charConversion = "off";
        this.debug = "off";
        this.unknown = "error";
        this.doubleQuotes = "codes";
        this.printStackTrace = "off";
        this.exception = NONE;
        this.startRuntime = this.features.contains((Object)Feature.STATISTICS_RUNTIME) ? System.currentTimeMillis() : 0L;
        this.previousRuntime = 0L;
        this.currentInput = this.userInput;
        this.currentOutput = this.userOutput;
    }

    public void requireFeature(Feature feature, Operation operation, Term term) {
        if (!this.features.contains((Object)feature)) {
            throw new PermissionException(operation, "use", feature.toString().toLowerCase(), term, "disabled");
        }
    }

    public void setB0() {
        this.B0 = this.stack.top();
    }

    public void cut(int n) {
        this.stack.cut(n);
    }

    public void neckCut() {
        this.stack.cut(this.B0);
    }

    public Term copy(Term term) {
        this.copyHash.clear();
        return term.copy(this);
    }

    public Operation fail() {
        ChoicePointFrame choicePointFrame = this.stack.top;
        this.B0 = choicePointFrame.b0;
        return choicePointFrame.bp;
    }

    public Operation switch_on_term(Operation operation, Operation operation2, Operation operation3, Operation operation4, Operation operation5, Operation operation6) {
        Term term = this.areg1.dereference();
        if (term.isVariable()) {
            return operation;
        }
        if (term.isInteger()) {
            return operation2;
        }
        if (term.isDouble()) {
            return operation3;
        }
        if (term.isSymbol()) {
            return operation4;
        }
        if (term.isStructure()) {
            return operation5;
        }
        if (term.isList()) {
            return operation6;
        }
        return operation;
    }

    public Operation switch_on_hash(HashMap<Term, Operation> hashMap, Operation operation) {
        Term term;
        Term term2 = this.areg1.dereference();
        if (term2.isInteger() || term2.isDouble() || term2.isSymbol()) {
            term = term2;
        } else if (term2.isStructure()) {
            term = ((StructureTerm)term2).functor();
        } else {
            throw new SystemException("Invalid argument in switch_on_hash");
        }
        Operation operation2 = hashMap.get(term);
        if (operation2 != null) {
            return operation2;
        }
        return operation;
    }

    public void restore() {
        this.stack.top.restore(this);
    }

    public Operation jtry0(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, ChoicePointFrame.S0(this.cont));
    }

    public Operation jtry1(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S1(this));
    }

    public Operation jtry2(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S2(this));
    }

    public Operation jtry3(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S3(this));
    }

    public Operation jtry4(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S4(this));
    }

    public Operation jtry5(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S5(this));
    }

    public Operation jtry6(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S6(this));
    }

    public Operation jtry7(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S7(this));
    }

    public Operation jtry8(Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S8(this));
    }

    public Operation jtry(int n, Operation operation, Operation operation2) {
        return this.finishjtry(operation, operation2, new ChoicePointFrame.S9(n, this));
    }

    private Operation finishjtry(Operation operation, Operation operation2, ChoicePointFrame choicePointFrame) {
        choicePointFrame.b0 = this.B0;
        choicePointFrame.bp = operation2;
        choicePointFrame.tr = this.trail.top();
        choicePointFrame.timeStamp = ++this.CPFTimeStamp;
        this.stack.push(choicePointFrame);
        return operation;
    }

    public Operation retry(Operation operation, Operation operation2) {
        this.restore();
        ChoicePointFrame choicePointFrame = this.stack.top;
        this.trail.unwind(choicePointFrame.tr);
        choicePointFrame.bp = operation2;
        return operation;
    }

    public Operation trust(Operation operation) {
        this.restore();
        this.trail.unwind(this.stack.top.tr);
        this.stack.delete();
        return operation;
    }

    Term makeStreamProperty(SymbolTerm symbolTerm, SymbolTerm symbolTerm2, SymbolTerm symbolTerm3, SymbolTerm symbolTerm4) {
        Term[] termArray = new Term[]{symbolTerm};
        Term[] termArray2 = new Term[]{symbolTerm3};
        Term[] termArray3 = new Term[]{symbolTerm4};
        Term term = Nil;
        term = new ListTerm(new StructureTerm(SYM_MODE_1, termArray), term);
        term = new ListTerm(symbolTerm2, term);
        term = new ListTerm(new StructureTerm(SYM_ALIAS_1, termArray2), term);
        term = new ListTerm(new StructureTerm(SYM_TYPE_1, termArray3), term);
        return term;
    }

    public long getCPFTimeStamp() {
        return this.CPFTimeStamp;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public int getMaxInteger() {
        return Integer.MAX_VALUE;
    }

    public int getMinInteger() {
        return Integer.MIN_VALUE;
    }

    public String getIntegerRoundingFunction() {
        return this.integerRoundingFunction;
    }

    public String getCharConversion() {
        return this.charConversion;
    }

    public void setCharConversion(String string) {
        this.charConversion = string;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String string) {
        this.debug = string;
    }

    public int getMaxArity() {
        return this.maxArity;
    }

    public String getUnknown() {
        return this.unknown;
    }

    public void setUnknown(String string) {
        this.unknown = string;
    }

    public String getDoubleQuotes() {
        return this.doubleQuotes;
    }

    public void setDoubleQuotes(String string) {
        this.doubleQuotes = string;
    }

    public String getPrintStackTrace() {
        return this.printStackTrace;
    }

    public void setPrintStackTrace(String string) {
        this.printStackTrace = string;
    }

    public Term getException() {
        return this.exception;
    }

    public void setException(Term term) {
        this.exception = term;
    }

    public long getStartRuntime() {
        return this.startRuntime;
    }

    public long getPreviousRuntime() {
        return this.previousRuntime;
    }

    public void setPreviousRuntime(long l) {
        this.previousRuntime = l;
    }

    public PushbackReader getUserInput() {
        return this.userInput;
    }

    public PrintWriter getUserOutput() {
        return this.userOutput;
    }

    public PrintWriter getUserError() {
        return this.userError;
    }

    public PushbackReader getCurrentInput() {
        return this.currentInput;
    }

    public void setCurrentInput(PushbackReader pushbackReader) {
        this.currentInput = pushbackReader;
    }

    public PrintWriter getCurrentOutput() {
        return this.currentOutput;
    }

    public void setCurrentOutput(PrintWriter printWriter) {
        this.currentOutput = printWriter;
    }

    public HashtableOfTerm getStreamManager() {
        return this.streamManager;
    }

    public HashtableOfTerm getHashManager() {
        return this.hashManager;
    }

    public static enum Feature {
        JAVA_REFLECTION,
        IO,
        STATISTICS_RUNTIME;

    }
}

