/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.InternalException;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public class StructureTerm
extends Term {
    protected SymbolTerm functor;
    protected Term[] args;

    public StructureTerm(String string, Term ... termArray) {
        this(SymbolTerm.create(string, termArray.length), termArray);
    }

    public StructureTerm(SymbolTerm symbolTerm, Term ... termArray) {
        if (symbolTerm.arity() != termArray.length) {
            throw new InternalException("Invalid argument length in StructureTerm");
        }
        this.functor = symbolTerm;
        this.args = termArray;
    }

    public SymbolTerm functor() {
        return this.functor;
    }

    @Override
    public int arity() {
        return this.args.length;
    }

    public Term[] args() {
        return this.args;
    }

    @Override
    public String name() {
        return this.functor.name();
    }

    @Override
    public Term arg(int n) {
        return this.args[n];
    }

    @Override
    public boolean unify(Term term, Trail trail) {
        if ((term = term.dereference()).isVariable()) {
            ((VariableTerm)term).bind(this, trail);
            return true;
        }
        if (!term.isStructure()) {
            return false;
        }
        if (!this.functor.equals(((StructureTerm)term).functor())) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].unify(((StructureTerm)term).args[i], trail)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Term copy(Prolog prolog) {
        Term[] termArray = new Term[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            termArray[i] = this.args[i].copy(prolog);
        }
        return new StructureTerm(this.functor, termArray);
    }

    @Override
    public boolean isGround() {
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].isGround()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toQuotedString() {
        String string = "";
        String string2 = this.functor.toQuotedString() + "(";
        for (int i = 0; i < this.args.length; ++i) {
            string2 = string2 + string + this.args[i].toQuotedString();
            string = ",";
        }
        string2 = string2 + ")";
        return string2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StructureTerm)) {
            return false;
        }
        if (!this.functor.equals(((StructureTerm)object).functor())) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(((StructureTerm)object).args[i].dereference())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.functor.hashCode();
        for (int i = 0; i < this.args.length; ++i) {
            n = 31 * n + this.args[i].dereference().hashCode();
        }
        return n;
    }

    public String toString() {
        String string = "";
        String string2 = this.functor.toString() + "(";
        for (int i = 0; i < this.args.length; ++i) {
            string2 = string2 + string + this.args[i].toString();
            string = ",";
        }
        string2 = string2 + ")";
        return string2;
    }

    @Override
    public int compareTo(Term term) {
        int n;
        Term[] termArray;
        SymbolTerm symbolTerm;
        Term term2;
        if (term.isVariable() || term.isNumber() || term.isSymbol()) {
            return 1;
        }
        if (term.isList()) {
            term2 = (ListTerm)term;
            symbolTerm = ListTerm.SYM_DOT;
            termArray = new Term[]{((ListTerm)term2).car(), ((ListTerm)term2).cdr()};
            n = 2;
        } else if (term.isStructure()) {
            term2 = (StructureTerm)term;
            symbolTerm = ((StructureTerm)term2).functor();
            termArray = ((StructureTerm)term2).args();
            n = ((StructureTerm)term2).arity();
        } else {
            return -1;
        }
        if (this.args.length != n) {
            return this.args.length - n;
        }
        if (!this.functor.equals(symbolTerm)) {
            return this.functor.compareTo(symbolTerm);
        }
        for (int i = 0; i < this.args.length; ++i) {
            int n2 = this.args[i].compareTo(termArray[i].dereference());
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }
}

