/*
 * Decompiled with CFR 0.152.
 */
package gerrit;

import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.rules.StoredValues;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.ChangeControl;
import com.googlecode.prolog_cafe.lang.IllegalTypeException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PInstantiationException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.Term;

class PRED__user_label_range_4
extends Predicate.P4 {
    PRED__user_label_range_4(Term a1, Term a2, Term a3, Term a4, Operation n) {
        this.arg1 = a1;
        this.arg2 = a2;
        this.arg3 = a3;
        this.arg4 = a4;
        this.cont = n;
    }

    @Override
    public Operation exec(Prolog engine) throws PrologException {
        engine.setB0();
        Term a1 = this.arg1.dereference();
        Term a2 = this.arg2.dereference();
        Term a3 = this.arg3.dereference();
        Term a4 = this.arg4.dereference();
        if (a1.isVariable()) {
            throw new PInstantiationException(this, 1);
        }
        if (!a1.isSymbol()) {
            throw new IllegalTypeException(this, 1, "atom", a1);
        }
        String label = a1.name();
        if (a2.isVariable()) {
            throw new PInstantiationException(this, 2);
        }
        if (!a2.isJavaObject() || !a2.convertible(CurrentUser.class)) {
            throw new IllegalTypeException(this, 2, "CurrentUser)", a2);
        }
        CurrentUser user = (CurrentUser)((JavaObjectTerm)a2).object();
        ChangeControl ctl = StoredValues.CHANGE_CONTROL.get(engine).forUser(user);
        PermissionRange range = ctl.getRange("label-" + label);
        if (range == null) {
            return engine.fail();
        }
        IntegerTerm min = new IntegerTerm(range.getMin());
        IntegerTerm max = new IntegerTerm(range.getMax());
        if (!a3.unify(min, engine.trail)) {
            return engine.fail();
        }
        if (!a4.unify(max, engine.trail)) {
            return engine.fail();
        }
        return this.cont;
    }
}

