/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth;

import java.io.IOException;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.AbstractUserAuth;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;

public class UserAuthKeyboardInteractive
extends AbstractUserAuth {
    private final String password;

    public UserAuthKeyboardInteractive(ClientSessionImpl session, String service, String username, String password) {
        super(session, service, username);
        this.password = password;
    }

    public UserAuth.Result next(Buffer buffer) throws IOException {
        if (buffer == null) {
            this.log.info("Send SSH_MSG_USERAUTH_REQUEST for password");
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST, 0);
            buffer.putString(this.username);
            buffer.putString(this.service);
            buffer.putString("keyboard-interactive");
            buffer.putString("");
            buffer.putString("");
            this.session.writePacket(buffer);
            return UserAuth.Result.Continued;
        }
        SshConstants.Message cmd = buffer.getCommand();
        this.log.info("Received {}", (Object)cmd);
        switch (cmd) {
            case SSH_MSG_USERAUTH_INFO_REQUEST: {
                String name = buffer.getString();
                String instruction = buffer.getString();
                String language_tag = buffer.getString();
                this.log.info("Received {} {} {}", name, instruction, language_tag);
                int num = buffer.getInt();
                Object[] prompt = new String[num];
                boolean[] echo = new boolean[num];
                for (int i = 0; i < num; ++i) {
                    prompt[i] = buffer.getString();
                    echo[i] = buffer.getByte() != 0;
                }
                this.log.info("Promt: {}", prompt);
                this.log.info("Echo: {}", (Object)echo);
                String[] rep = null;
                if (num == 0) {
                    rep = new String[]{};
                } else if (num == 1 && this.password != null && !echo[0] && ((String)prompt[0]).toLowerCase().startsWith("password:")) {
                    rep = new String[]{this.password};
                } else {
                    UserInteraction ui = this.session.getClientFactoryManager().getUserInteraction();
                    if (ui != null) {
                        String dest = this.username + "@" + this.session.getIoSession().getRemoteAddress().toString();
                        rep = ui.interactive(dest, name, instruction, (String[])prompt, echo);
                    }
                }
                if (rep == null) {
                    return UserAuth.Result.Failure;
                }
                buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_INFO_RESPONSE, 0);
                buffer.putInt(rep.length);
                for (String r : rep) {
                    buffer.putString(r);
                }
                this.session.writePacket(buffer);
                return UserAuth.Result.Continued;
            }
            case SSH_MSG_USERAUTH_SUCCESS: {
                return UserAuth.Result.Success;
            }
            case SSH_MSG_USERAUTH_FAILURE: {
                return UserAuth.Result.Failure;
            }
        }
        return UserAuth.Result.Continued;
    }
}

