/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.net.SocketAddress;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.sshd.common.future.DefaultSshFuture;
import org.apache.sshd.common.io.IoCloseFuture;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.mina.MinaService;
import org.apache.sshd.common.io.mina.MinaSupport;
import org.apache.sshd.common.util.Buffer;

public class MinaSession
implements IoSession {
    private final MinaService service;
    private final org.apache.mina.core.session.IoSession session;

    public MinaSession(MinaService service, org.apache.mina.core.session.IoSession session) {
        this.service = service;
        this.session = session;
    }

    public org.apache.mina.core.session.IoSession getSession() {
        return this.session;
    }

    public void suspend() {
        this.session.suspendRead();
        this.session.suspendWrite();
    }

    public Object getAttribute(Object key) {
        return this.session.getAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.session.setAttribute(key, value);
    }

    public SocketAddress getRemoteAddress() {
        return this.session.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.session.getLocalAddress();
    }

    public long getId() {
        return this.session.getId();
    }

    public WriteFuture write(byte[] data, int offset, int len) {
        IoBuffer buffer = IoBuffer.wrap(data, offset, len);
        return this.session.write(buffer);
    }

    public IoCloseFuture close(boolean immediately) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Future
        extends DefaultSshFuture<IoCloseFuture>
        implements IoCloseFuture {
            Future(Object lock) {
                super(lock);
            }

            @Override
            public boolean isClosed() {
                return this.getValue() instanceof Boolean;
            }

            @Override
            public void setClosed() {
                this.setValue(Boolean.TRUE);
            }
        }
        final Future future = new Future(null);
        this.session.close(immediately).addListener(new IoFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture cf) {
                future.setClosed();
            }
        });
        return future;
    }

    public IoWriteFuture write(Buffer buffer) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Future
        extends DefaultSshFuture<IoWriteFuture>
        implements IoWriteFuture {
            Future(Object lock) {
                super(lock);
            }

            @Override
            public boolean isWritten() {
                return this.getValue() instanceof Boolean;
            }

            @Override
            public void setWritten() {
                this.setValue(Boolean.TRUE);
            }

            @Override
            public Throwable getException() {
                Object v = this.getValue();
                return v instanceof Throwable ? (Throwable)v : null;
            }

            @Override
            public void setException(Throwable exception) {
                if (exception == null) {
                    throw new IllegalArgumentException("exception");
                }
                this.setValue(exception);
            }
        }
        final Future future = new Future(null);
        this.session.write(MinaSupport.asIoBuffer(buffer)).addListener(new IoFutureListener<WriteFuture>(){

            @Override
            public void operationComplete(WriteFuture cf) {
                if (cf.getException() != null) {
                    future.setException(cf.getException());
                } else {
                    future.setWritten();
                }
            }
        });
        return future;
    }

    public IoService getService() {
        return this.service;
    }
}

