/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.apache.sshd.common.util.SecurityUtils;

public class DH {
    private BigInteger p;
    private BigInteger g;
    private BigInteger e;
    private byte[] e_array;
    private BigInteger f;
    private BigInteger K;
    private byte[] K_array;
    private KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("DH");
    private KeyAgreement myKeyAgree = SecurityUtils.getKeyAgreement("DH");

    public byte[] getE() throws Exception {
        if (this.e == null) {
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
            this.myKpairGen.initialize(dhSkipParamSpec);
            KeyPair myKpair = this.myKpairGen.generateKeyPair();
            this.myKeyAgree.init(myKpair.getPrivate());
            this.e = ((DHPublicKey)myKpair.getPublic()).getY();
            this.e_array = this.e.toByteArray();
        }
        return this.e_array;
    }

    public byte[] getK() throws Exception {
        if (this.K == null) {
            KeyFactory myKeyFac = SecurityUtils.getKeyFactory("DH");
            DHPublicKeySpec keySpec = new DHPublicKeySpec(this.f, this.p, this.g);
            PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
            this.myKeyAgree.doPhase(yourPubKey, true);
            byte[] mySharedSecret = DH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
            this.K = new BigInteger(mySharedSecret);
            this.K_array = mySharedSecret;
        }
        return this.K_array;
    }

    public void setP(byte[] p) {
        this.setP(new BigInteger(p));
    }

    public void setG(byte[] g) {
        this.setG(new BigInteger(g));
    }

    public void setF(byte[] f) {
        this.setF(new BigInteger(f));
    }

    void setP(BigInteger p) {
        this.p = p;
    }

    void setG(BigInteger g) {
        this.g = g;
    }

    void setF(BigInteger f) {
        this.f = f;
    }

    private static byte[] stripLeadingZeroes(byte[] x) {
        int i;
        for (i = 0; i < x.length - 1 && x[i] == 0; ++i) {
        }
        byte[] ret = new byte[x.length - i];
        System.arraycopy(x, i, ret, 0, ret.length);
        return ret;
    }
}

