/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server.glue;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.glue.WrappedRequest;

public class RegexGroupFilter
implements Filter {
    private final int groupIdx;

    public RegexGroupFilter(int groupIdx) {
        if (groupIdx < 1) {
            throw new IllegalArgumentException(MessageFormat.format(HttpServerText.get().invalidIndex, groupIdx));
        }
        this.groupIdx = groupIdx - 1;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        WrappedRequest[] g = RegexGroupFilter.groupsFor(request);
        if (this.groupIdx >= g.length) {
            throw new ServletException(MessageFormat.format(HttpServerText.get().invalidRegexGroup, this.groupIdx + 1));
        }
        chain.doFilter(g[this.groupIdx], rsp);
    }

    private static WrappedRequest[] groupsFor(ServletRequest r) {
        return (WrappedRequest[])r.getAttribute("org.eclipse.jgit.http.server.glue.MetaServlet.serveRegex");
    }
}

