/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.IO;

public class ObjectIdSerialization {
    public static void writeCanBeNull(OutputStream out, AnyObjectId id) throws IOException {
        if (id != null) {
            out.write(1);
            ObjectIdSerialization.writeNotNull(out, id);
        } else {
            out.write(0);
        }
    }

    public static void writeNotNull(OutputStream out, AnyObjectId id) throws IOException {
        id.copyRawTo(out);
    }

    public static ObjectId readCanBeNull(InputStream in) throws IOException {
        switch (in.read()) {
            case 0: {
                return null;
            }
            case 1: {
                return ObjectIdSerialization.readNotNull(in);
            }
        }
        throw new IOException("Invalid flag before ObjectId");
    }

    public static ObjectId readNotNull(InputStream in) throws IOException {
        byte[] b = new byte[20];
        IO.readFully(in, b, 0, 20);
        return ObjectId.fromRaw(b);
    }

    private ObjectIdSerialization() {
    }
}

