// Copyright (C) 2012 The Android Open Source Project
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.gerrit.rules;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.extensions.annotations.ExtensionPoint;

import com.googlecode.prolog_cafe.lang.Predicate;

/**
 * Provides additional packages that contain Prolog predicates that should be
 * made available in the Prolog environment. The predicates can e.g. be used in
 * the project submit rules.
 *
 * Each Java class defining a Prolog predicate must be in one of the provided
 * packages and its name must apply to the 'PRED_[functor]_[arity]' format. In
 * addition it must extend {@link Predicate}.
 */
@ExtensionPoint
public interface PredicateProvider {
  /** Return set of packages that contain Prolog predicates */
  public ImmutableSet<String> getPackages();
}
