
package com.google.gerrit.server.notedb;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Change.Id;
import com.google.gerrit.server.git.InsertedObject;
import javax.annotation.Generated;
import org.eclipse.jgit.transport.ReceiveCommand;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_NoteDbUpdateManager_StagedResult extends NoteDbUpdateManager.StagedResult {

  private final Id id;
  private final NoteDbChangeState.Delta delta;
  private final ImmutableList<ReceiveCommand> changeCommands;
  private final ImmutableList<InsertedObject> changeObjects;
  private final ImmutableList<ReceiveCommand> allUsersCommands;
  private final ImmutableList<InsertedObject> allUsersObjects;

  AutoValue_NoteDbUpdateManager_StagedResult(
      Id id,
      @Nullable NoteDbChangeState.Delta delta,
      ImmutableList<ReceiveCommand> changeCommands,
      ImmutableList<InsertedObject> changeObjects,
      ImmutableList<ReceiveCommand> allUsersCommands,
      ImmutableList<InsertedObject> allUsersObjects) {
    if (id == null) {
      throw new NullPointerException("Null id");
    }
    this.id = id;
    this.delta = delta;
    if (changeCommands == null) {
      throw new NullPointerException("Null changeCommands");
    }
    this.changeCommands = changeCommands;
    if (changeObjects == null) {
      throw new NullPointerException("Null changeObjects");
    }
    this.changeObjects = changeObjects;
    if (allUsersCommands == null) {
      throw new NullPointerException("Null allUsersCommands");
    }
    this.allUsersCommands = allUsersCommands;
    if (allUsersObjects == null) {
      throw new NullPointerException("Null allUsersObjects");
    }
    this.allUsersObjects = allUsersObjects;
  }

  @Override
  public Id id() {
    return id;
  }

  @Nullable
  @Override
  public NoteDbChangeState.Delta delta() {
    return delta;
  }

  @Override
  public ImmutableList<ReceiveCommand> changeCommands() {
    return changeCommands;
  }

  @Override
  public ImmutableList<InsertedObject> changeObjects() {
    return changeObjects;
  }

  @Override
  public ImmutableList<ReceiveCommand> allUsersCommands() {
    return allUsersCommands;
  }

  @Override
  public ImmutableList<InsertedObject> allUsersObjects() {
    return allUsersObjects;
  }

  @Override
  public String toString() {
    return "StagedResult{"
        + "id=" + id + ", "
        + "delta=" + delta + ", "
        + "changeCommands=" + changeCommands + ", "
        + "changeObjects=" + changeObjects + ", "
        + "allUsersCommands=" + allUsersCommands + ", "
        + "allUsersObjects=" + allUsersObjects
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NoteDbUpdateManager.StagedResult) {
      NoteDbUpdateManager.StagedResult that = (NoteDbUpdateManager.StagedResult) o;
      return (this.id.equals(that.id()))
           && ((this.delta == null) ? (that.delta() == null) : this.delta.equals(that.delta()))
           && (this.changeCommands.equals(that.changeCommands()))
           && (this.changeObjects.equals(that.changeObjects()))
           && (this.allUsersCommands.equals(that.allUsersCommands()))
           && (this.allUsersObjects.equals(that.allUsersObjects()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.id.hashCode();
    h *= 1000003;
    h ^= (delta == null) ? 0 : this.delta.hashCode();
    h *= 1000003;
    h ^= this.changeCommands.hashCode();
    h *= 1000003;
    h ^= this.changeObjects.hashCode();
    h *= 1000003;
    h ^= this.allUsersCommands.hashCode();
    h *= 1000003;
    h ^= this.allUsersObjects.hashCode();
    return h;
  }

}
