
package com.google.gerrit.server.notedb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ChangeNotesState extends ChangeNotesState {

  private final com.google.gerrit.reviewdb.client.Change.Id changeId;
  private final ChangeNotesState.ChangeColumns columns;
  private final ImmutableSet<String> hashtags;
  private final ImmutableSortedMap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSet> patchSets;
  private final ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSetApproval> approvals;
  private final ReviewerSet reviewers;
  private final ImmutableList<com.google.gerrit.reviewdb.client.Account.Id> allPastReviewers;
  private final ImmutableList<ReviewerStatusUpdate> reviewerUpdates;
  private final ImmutableList<SubmitRecord> submitRecords;
  private final ImmutableList<ChangeMessage> allChangeMessages;
  private final ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, ChangeMessage> changeMessagesByPatchSet;
  private final ImmutableListMultimap<RevId, PatchLineComment> publishedComments;

  AutoValue_ChangeNotesState(
      com.google.gerrit.reviewdb.client.Change.Id changeId,
      @Nullable ChangeNotesState.ChangeColumns columns,
      ImmutableSet<String> hashtags,
      ImmutableSortedMap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSet> patchSets,
      ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSetApproval> approvals,
      ReviewerSet reviewers,
      ImmutableList<com.google.gerrit.reviewdb.client.Account.Id> allPastReviewers,
      ImmutableList<ReviewerStatusUpdate> reviewerUpdates,
      ImmutableList<SubmitRecord> submitRecords,
      ImmutableList<ChangeMessage> allChangeMessages,
      ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, ChangeMessage> changeMessagesByPatchSet,
      ImmutableListMultimap<RevId, PatchLineComment> publishedComments) {
    if (changeId == null) {
      throw new NullPointerException("Null changeId");
    }
    this.changeId = changeId;
    this.columns = columns;
    if (hashtags == null) {
      throw new NullPointerException("Null hashtags");
    }
    this.hashtags = hashtags;
    if (patchSets == null) {
      throw new NullPointerException("Null patchSets");
    }
    this.patchSets = patchSets;
    if (approvals == null) {
      throw new NullPointerException("Null approvals");
    }
    this.approvals = approvals;
    if (reviewers == null) {
      throw new NullPointerException("Null reviewers");
    }
    this.reviewers = reviewers;
    if (allPastReviewers == null) {
      throw new NullPointerException("Null allPastReviewers");
    }
    this.allPastReviewers = allPastReviewers;
    if (reviewerUpdates == null) {
      throw new NullPointerException("Null reviewerUpdates");
    }
    this.reviewerUpdates = reviewerUpdates;
    if (submitRecords == null) {
      throw new NullPointerException("Null submitRecords");
    }
    this.submitRecords = submitRecords;
    if (allChangeMessages == null) {
      throw new NullPointerException("Null allChangeMessages");
    }
    this.allChangeMessages = allChangeMessages;
    if (changeMessagesByPatchSet == null) {
      throw new NullPointerException("Null changeMessagesByPatchSet");
    }
    this.changeMessagesByPatchSet = changeMessagesByPatchSet;
    if (publishedComments == null) {
      throw new NullPointerException("Null publishedComments");
    }
    this.publishedComments = publishedComments;
  }

  @Override
  com.google.gerrit.reviewdb.client.Change.Id changeId() {
    return changeId;
  }

  @Nullable
  @Override
  ChangeNotesState.ChangeColumns columns() {
    return columns;
  }

  @Override
  ImmutableSet<String> hashtags() {
    return hashtags;
  }

  @Override
  ImmutableSortedMap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSet> patchSets() {
    return patchSets;
  }

  @Override
  ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, PatchSetApproval> approvals() {
    return approvals;
  }

  @Override
  ReviewerSet reviewers() {
    return reviewers;
  }

  @Override
  ImmutableList<com.google.gerrit.reviewdb.client.Account.Id> allPastReviewers() {
    return allPastReviewers;
  }

  @Override
  ImmutableList<ReviewerStatusUpdate> reviewerUpdates() {
    return reviewerUpdates;
  }

  @Override
  ImmutableList<SubmitRecord> submitRecords() {
    return submitRecords;
  }

  @Override
  ImmutableList<ChangeMessage> allChangeMessages() {
    return allChangeMessages;
  }

  @Override
  ImmutableListMultimap<com.google.gerrit.reviewdb.client.PatchSet.Id, ChangeMessage> changeMessagesByPatchSet() {
    return changeMessagesByPatchSet;
  }

  @Override
  ImmutableListMultimap<RevId, PatchLineComment> publishedComments() {
    return publishedComments;
  }

  @Override
  public String toString() {
    return "ChangeNotesState{"
        + "changeId=" + changeId + ", "
        + "columns=" + columns + ", "
        + "hashtags=" + hashtags + ", "
        + "patchSets=" + patchSets + ", "
        + "approvals=" + approvals + ", "
        + "reviewers=" + reviewers + ", "
        + "allPastReviewers=" + allPastReviewers + ", "
        + "reviewerUpdates=" + reviewerUpdates + ", "
        + "submitRecords=" + submitRecords + ", "
        + "allChangeMessages=" + allChangeMessages + ", "
        + "changeMessagesByPatchSet=" + changeMessagesByPatchSet + ", "
        + "publishedComments=" + publishedComments
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ChangeNotesState) {
      ChangeNotesState that = (ChangeNotesState) o;
      return (this.changeId.equals(that.changeId()))
           && ((this.columns == null) ? (that.columns() == null) : this.columns.equals(that.columns()))
           && (this.hashtags.equals(that.hashtags()))
           && (this.patchSets.equals(that.patchSets()))
           && (this.approvals.equals(that.approvals()))
           && (this.reviewers.equals(that.reviewers()))
           && (this.allPastReviewers.equals(that.allPastReviewers()))
           && (this.reviewerUpdates.equals(that.reviewerUpdates()))
           && (this.submitRecords.equals(that.submitRecords()))
           && (this.allChangeMessages.equals(that.allChangeMessages()))
           && (this.changeMessagesByPatchSet.equals(that.changeMessagesByPatchSet()))
           && (this.publishedComments.equals(that.publishedComments()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.changeId.hashCode();
    h *= 1000003;
    h ^= (columns == null) ? 0 : this.columns.hashCode();
    h *= 1000003;
    h ^= this.hashtags.hashCode();
    h *= 1000003;
    h ^= this.patchSets.hashCode();
    h *= 1000003;
    h ^= this.approvals.hashCode();
    h *= 1000003;
    h ^= this.reviewers.hashCode();
    h *= 1000003;
    h ^= this.allPastReviewers.hashCode();
    h *= 1000003;
    h ^= this.reviewerUpdates.hashCode();
    h *= 1000003;
    h ^= this.submitRecords.hashCode();
    h *= 1000003;
    h ^= this.allChangeMessages.hashCode();
    h *= 1000003;
    h ^= this.changeMessagesByPatchSet.hashCode();
    h *= 1000003;
    h ^= this.publishedComments.hashCode();
    return h;
  }

}
