
package com.google.gerrit.server.patch;

import com.google.gerrit.extensions.client.DiffPreferencesInfo.Whitespace;
import javax.annotation.Generated;
import org.eclipse.jgit.lib.ObjectId;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_IntraLineDiffKey extends IntraLineDiffKey {

  private final ObjectId blobA;
  private final ObjectId blobB;
  private final Whitespace whitespace;

  AutoValue_IntraLineDiffKey(
      ObjectId blobA,
      ObjectId blobB,
      Whitespace whitespace) {
    if (blobA == null) {
      throw new NullPointerException("Null blobA");
    }
    this.blobA = blobA;
    if (blobB == null) {
      throw new NullPointerException("Null blobB");
    }
    this.blobB = blobB;
    if (whitespace == null) {
      throw new NullPointerException("Null whitespace");
    }
    this.whitespace = whitespace;
  }

  @Override
  public ObjectId getBlobA() {
    return blobA;
  }

  @Override
  public ObjectId getBlobB() {
    return blobB;
  }

  @Override
  public Whitespace getWhitespace() {
    return whitespace;
  }

  @Override
  public String toString() {
    return "IntraLineDiffKey{"
        + "blobA=" + blobA + ", "
        + "blobB=" + blobB + ", "
        + "whitespace=" + whitespace
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof IntraLineDiffKey) {
      IntraLineDiffKey that = (IntraLineDiffKey) o;
      return (this.blobA.equals(that.getBlobA()))
           && (this.blobB.equals(that.getBlobB()))
           && (this.whitespace.equals(that.getWhitespace()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.blobA.hashCode();
    h *= 1000003;
    h ^= this.blobB.hashCode();
    h *= 1000003;
    h ^= this.whitespace.hashCode();
    return h;
  }

  private static final long serialVersionUID = 5L;

}
