/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.errorprone.annotations.CompileTimeConstant;

@GwtCompatible
public final class SafeScripts {
    private SafeScripts() {
    }

    public static SafeScript fromConstant(@CompileTimeConstant String script) {
        if (script.length() == 0) {
            return SafeScript.EMPTY;
        }
        return SafeScripts.create(script);
    }

    public static SafeScript fromProto(SafeScriptProto proto) {
        return SafeScripts.create(proto.getPrivateDoNotAccessOrElseSafeScriptWrappedValue());
    }

    public static SafeScriptProto toProto(SafeScript script) {
        return SafeScriptProto.newBuilder().setPrivateDoNotAccessOrElseSafeScriptWrappedValue(script.getSafeScriptString()).build();
    }

    static SafeScript create(String script) {
        return new SafeScript(script);
    }
}

