/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.common.annotations.GwtIncompatible;
import com.google.gerrit.common.Die;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.IO;

@GwtIncompatible(value="Unemulated classes in java.io, java.nio and JGit")
public class FileUtil {
    public static boolean modified(FileBasedConfig cfg) throws IOException {
        byte[] curVers;
        try {
            curVers = IO.readFully(cfg.getFile());
        }
        catch (FileNotFoundException notFound) {
            return true;
        }
        byte[] newVers = Constants.encode(cfg.toText());
        return !Arrays.equals(curVers, newVers);
    }

    public static void mkdir(File path) {
        if (!path.isDirectory() && !path.mkdir()) {
            throw new Die("Cannot make directory " + path);
        }
    }

    public static void chmod(int mode, Path path) {
        FileUtil.chmod(mode, path.toFile());
    }

    public static void chmod(int mode, File path) {
        path.setReadable(false, false);
        path.setWritable(false, false);
        path.setExecutable(false, false);
        path.setReadable((mode & 0x100) == 256, true);
        path.setWritable((mode & 0x80) == 128, true);
        if (path.isDirectory() || (mode & 0x40) == 64) {
            path.setExecutable(true, true);
        }
        if ((mode & 0x24) == 36) {
            path.setReadable(true, false);
        }
        if ((mode & 9) == 9) {
            path.setExecutable(true, false);
        }
    }

    public static long lastModified(Path p) {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static Path mkdirsOrDie(Path p, String errMsg) {
        try {
            if (!Files.isDirectory(p, new LinkOption[0])) {
                Files.createDirectories(p, new FileAttribute[0]);
            }
            return p;
        }
        catch (IOException e) {
            throw new Die(errMsg + ": " + p, e);
        }
    }

    private FileUtil() {
    }
}

