/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.prettify.common.EditList;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import java.util.List;
import org.eclipse.jgit.diff.Edit;

public class PatchScript {
    private Change.Key changeId;
    private Patch.ChangeType changeType;
    private String oldName;
    private String newName;
    private FileMode oldMode;
    private FileMode newMode;
    private List<String> header;
    private DiffPreferencesInfo diffPrefs;
    private SparseFileContent a;
    private SparseFileContent b;
    private List<Edit> edits;
    private DisplayMethod displayMethodA;
    private DisplayMethod displayMethodB;
    private transient String mimeTypeA;
    private transient String mimeTypeB;
    private CommentDetail comments;
    private List<Patch> history;
    private boolean hugeFile;
    private boolean intralineDifference;
    private boolean intralineFailure;
    private boolean intralineTimeout;
    private boolean binary;
    private transient String commitIdA;
    private transient String commitIdB;

    public PatchScript(Change.Key ck, Patch.ChangeType ct, String on, String nn, FileMode om, FileMode nm, List<String> h, DiffPreferencesInfo dp, SparseFileContent ca, SparseFileContent cb, List<Edit> e, DisplayMethod ma, DisplayMethod mb, String mta, String mtb, CommentDetail cd, List<Patch> hist, boolean hf, boolean id, boolean idf, boolean idt, boolean bin, String cma, String cmb) {
        this.changeId = ck;
        this.changeType = ct;
        this.oldName = on;
        this.newName = nn;
        this.oldMode = om;
        this.newMode = nm;
        this.header = h;
        this.diffPrefs = dp;
        this.a = ca;
        this.b = cb;
        this.edits = e;
        this.displayMethodA = ma;
        this.displayMethodB = mb;
        this.mimeTypeA = mta;
        this.mimeTypeB = mtb;
        this.comments = cd;
        this.history = hist;
        this.hugeFile = hf;
        this.intralineDifference = id;
        this.intralineFailure = idf;
        this.intralineTimeout = idt;
        this.binary = bin;
        this.commitIdA = cma;
        this.commitIdB = cmb;
    }

    protected PatchScript() {
    }

    public Change.Key getChangeId() {
        return this.changeId;
    }

    public DisplayMethod getDisplayMethodA() {
        return this.displayMethodA;
    }

    public DisplayMethod getDisplayMethodB() {
        return this.displayMethodB;
    }

    public FileMode getFileModeA() {
        return this.oldMode;
    }

    public FileMode getFileModeB() {
        return this.newMode;
    }

    public List<String> getPatchHeader() {
        return this.header;
    }

    public Patch.ChangeType getChangeType() {
        return this.changeType;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public CommentDetail getCommentDetail() {
        return this.comments;
    }

    public List<Patch> getHistory() {
        return this.history;
    }

    public DiffPreferencesInfo getDiffPrefs() {
        return this.diffPrefs;
    }

    public void setDiffPrefs(DiffPreferencesInfo dp) {
        this.diffPrefs = dp;
    }

    public boolean isHugeFile() {
        return this.hugeFile;
    }

    public boolean isIgnoreWhitespace() {
        return this.diffPrefs.ignoreWhitespace != DiffPreferencesInfo.Whitespace.IGNORE_NONE;
    }

    public boolean hasIntralineDifference() {
        return this.intralineDifference;
    }

    public boolean hasIntralineFailure() {
        return this.intralineFailure;
    }

    public boolean hasIntralineTimeout() {
        return this.intralineTimeout;
    }

    public boolean isExpandAllComments() {
        return this.diffPrefs.expandAllComments;
    }

    public SparseFileContent getA() {
        return this.a;
    }

    public SparseFileContent getB() {
        return this.b;
    }

    public String getMimeTypeA() {
        return this.mimeTypeA;
    }

    public String getMimeTypeB() {
        return this.mimeTypeB;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public Iterable<EditList.Hunk> getHunks() {
        int ctx = this.diffPrefs.context;
        if (ctx == -1) {
            ctx = Math.max(this.a.size(), this.b.size());
        }
        return new EditList(this.edits, ctx, this.a.size(), this.b.size()).getHunks();
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getCommitIdA() {
        return this.commitIdA;
    }

    public String getCommitIdB() {
        return this.commitIdB;
    }

    public static enum FileMode {
        FILE,
        SYMLINK,
        GITLINK;

    }

    public static enum DisplayMethod {
        NONE,
        DIFF,
        IMG;

    }
}

