/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jgit.util.Base64;

public class RemoteUserUtil {
    public static String getRemoteUser(HttpServletRequest req, String loginHeader) {
        if ("Authorization".equals(loginHeader)) {
            String user = Strings.emptyToNull(req.getRemoteUser());
            if (user != null) {
                return user;
            }
            String auth = req.getHeader("Authorization");
            return RemoteUserUtil.extractUsername(auth);
        }
        return Strings.emptyToNull(req.getHeader(loginHeader));
    }

    public static String extractUsername(String auth) {
        if ((auth = Strings.emptyToNull(auth)) == null) {
            return null;
        }
        if (auth.startsWith("Basic ")) {
            auth = auth.substring("Basic ".length());
            int c = (auth = new String(Base64.decode(auth), StandardCharsets.UTF_8)).indexOf(58);
            return c > 0 ? auth.substring(0, c) : null;
        }
        if (auth.startsWith("Digest ")) {
            int u = auth.indexOf("username=\"");
            if (u <= 0) {
                return null;
            }
            int e = (auth = auth.substring(u + 10)).indexOf(34);
            return e > 0 ? auth.substring(0, e) : null;
        }
        return null;
    }
}

