/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.cache.Cache;
import com.google.gerrit.httpd.raw.BazelBuild;
import com.google.gerrit.httpd.raw.ResourceServlet;
import com.google.gerrit.launcher.GerritLauncher;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

class FontsDevServlet
extends ResourceServlet {
    private static final long serialVersionUID = 1L;
    private final Path fonts;

    FontsDevServlet(Cache<Path, ResourceServlet.Resource> cache, BazelBuild builder) throws IOException {
        super(cache, true);
        Objects.requireNonNull(builder);
        BazelBuild.Label zipLabel = builder.fontZipLabel();
        try {
            builder.build(zipLabel);
        }
        catch (BazelBuild.BuildFailureException e) {
            throw new IOException(e);
        }
        Path zip = builder.targetPath(zipLabel);
        Objects.requireNonNull(zip);
        this.fonts = GerritLauncher.newZipFileSystem(zip).getPath("/", new String[0]);
    }

    @Override
    protected Path getResourcePath(String pathInfo) throws IOException {
        return this.fonts.resolve(pathInfo);
    }
}

