/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.dropwizard.BucketedMetric;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class MetricJson {
    String description;
    String unit;
    Boolean constant;
    Boolean rate;
    Boolean gauge;
    Boolean cumulative;
    Long count;
    Object value;
    Double rate_1m;
    Double rate_5m;
    Double rate_15m;
    Double rate_mean;
    Double p50;
    Double p75;
    Double p95;
    Double p98;
    Double p99;
    Double p99_9;
    Double min;
    Double avg;
    Double max;
    Double sum;
    Double std_dev;
    List<FieldJson> fields;
    Map<String, Object> buckets;

    MetricJson(Metric metric, ImmutableMap<String, String> atts, boolean dataOnly) {
        if (!dataOnly) {
            this.description = atts.get("DESCRIPTION");
            this.unit = atts.get("UNIT");
            this.constant = MetricJson.toBool(atts, "CONSTANT");
            this.rate = MetricJson.toBool(atts, "RATE");
            this.gauge = MetricJson.toBool(atts, "GAUGE");
            this.cumulative = MetricJson.toBool(atts, "CUMULATIVE");
        }
        this.init(metric, atts);
    }

    private void init(Metric metric, ImmutableMap<String, String> atts) {
        if (metric instanceof BucketedMetric) {
            BucketedMetric m = (BucketedMetric)metric;
            if (m.getTotal() != null) {
                this.init(m.getTotal(), atts);
            }
            Field<?>[] fieldList = m.getFields();
            this.fields = new ArrayList<FieldJson>(fieldList.length);
            for (Field<?> f : fieldList) {
                this.fields.add(new FieldJson(f));
            }
            this.buckets = MetricJson.makeBuckets(fieldList, m.getCells(), atts);
        } else if (metric instanceof Counter) {
            Counter c = (Counter)metric;
            this.count = c.getCount();
        } else if (metric instanceof Gauge) {
            Gauge g = (Gauge)metric;
            this.value = g.getValue();
        } else if (metric instanceof Meter) {
            Meter m = (Meter)metric;
            this.count = m.getCount();
            this.rate_1m = m.getOneMinuteRate();
            this.rate_5m = m.getFiveMinuteRate();
            this.rate_15m = m.getFifteenMinuteRate();
        } else if (metric instanceof Timer) {
            Timer m = (Timer)metric;
            Snapshot s = m.getSnapshot();
            this.count = m.getCount();
            this.rate_1m = m.getOneMinuteRate();
            this.rate_5m = m.getFiveMinuteRate();
            this.rate_15m = m.getFifteenMinuteRate();
            double div = Description.getTimeUnit(atts.get("UNIT")).toNanos(1L);
            this.p50 = s.getMedian() / div;
            this.p75 = s.get75thPercentile() / div;
            this.p95 = s.get95thPercentile() / div;
            this.p98 = s.get98thPercentile() / div;
            this.p99 = s.get99thPercentile() / div;
            this.p99_9 = s.get999thPercentile() / div;
            this.min = (double)s.getMin() / div;
            this.max = (double)s.getMax() / div;
            this.std_dev = s.getStdDev() / div;
        } else if (metric instanceof Histogram) {
            Histogram m = (Histogram)metric;
            Snapshot s = m.getSnapshot();
            this.count = m.getCount();
            this.p50 = s.getMedian();
            this.p75 = s.get75thPercentile();
            this.p95 = s.get95thPercentile();
            this.p98 = s.get98thPercentile();
            this.p99 = s.get99thPercentile();
            this.p99_9 = s.get999thPercentile();
            this.min = s.getMin();
            this.avg = s.getMean();
            this.max = s.getMax();
            this.sum = s.getMean() * (double)m.getCount();
            this.std_dev = s.getStdDev();
        }
    }

    private static Boolean toBool(ImmutableMap<String, String> atts, String key) {
        return "1".equals(atts.get(key)) ? Boolean.valueOf(true) : null;
    }

    private static Map<String, Object> makeBuckets(Field<?>[] fields, Map<?, Metric> metrics, ImmutableMap<String, String> atts) {
        if (fields.length == 1) {
            Function<?, String> fmt = fields[0].formatter();
            TreeMap<String, Object> out = new TreeMap<String, Object>();
            for (Map.Entry<?, Metric> e : metrics.entrySet()) {
                out.put(fmt.apply(e.getKey()), new MetricJson(e.getValue(), atts, true));
            }
            return out;
        }
        TreeMap<String, Object> out = new TreeMap<String, Object>();
        for (Map.Entry<?, Metric> e : metrics.entrySet()) {
            ImmutableList keys = (ImmutableList)e.getKey();
            TreeMap<String, Object> dst = out;
            for (int i = 0; i < fields.length - 1; ++i) {
                Function<?, String> fmt = fields[i].formatter();
                String key = fmt.apply(keys.get(i));
                TreeMap t = (TreeMap)dst.get(key);
                if (t == null) {
                    t = new TreeMap();
                    dst.put(key, t);
                }
                dst = t;
            }
            Function<?, String> fmt = fields[fields.length - 1].formatter();
            dst.put(fmt.apply(keys.get(fields.length - 1)), new MetricJson(e.getValue(), atts, true));
        }
        return out;
    }

    static class FieldJson {
        String name;
        String type;
        String description;

        FieldJson(Field<?> field) {
            this.name = field.getName();
            this.description = field.getDescription();
            this.type = Enum.class.isAssignableFrom(field.getType()) ? field.getType().getSimpleName() : null;
        }
    }
}

