/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.RepoSequence;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.jgit.lib.Config;

@Singleton
public class Sequences {
    public static final String CHANGES = "changes";
    private final Provider<ReviewDb> db;
    private final NotesMigration migration;
    private final RepoSequence changeSeq;

    @Inject
    Sequences(@GerritServerConfig Config cfg, final Provider<ReviewDb> db, NotesMigration migration, GitRepositoryManager repoManager, AllProjectsName allProjects) {
        this.db = db;
        this.migration = migration;
        final int gap = cfg.getInt("noteDb", CHANGES, "initialSequenceGap", 0);
        this.changeSeq = new RepoSequence(repoManager, allProjects, CHANGES, new RepoSequence.Seed(){

            @Override
            public int get() throws OrmException {
                return ((ReviewDb)db.get()).nextChangeId() + gap;
            }
        }, cfg.getInt("noteDb", CHANGES, "sequenceBatchSize", 20));
    }

    public int nextChangeId() throws OrmException {
        if (!this.migration.readChangeSequence()) {
            return this.db.get().nextChangeId();
        }
        return this.changeSeq.next();
    }

    public ImmutableList<Integer> nextChangeIds(int count) throws OrmException {
        if (this.migration.readChangeSequence()) {
            return this.changeSeq.next(count);
        }
        if (count == 0) {
            return ImmutableList.of();
        }
        Preconditions.checkArgument(count > 0, "count is negative: %s", count);
        ArrayList<Integer> ids = new ArrayList<Integer>(count);
        ReviewDb db = this.db.get();
        for (int i = 0; i < count; ++i) {
            ids.add(db.nextChangeId());
        }
        return ImmutableList.copyOf(ids);
    }

    @VisibleForTesting
    public RepoSequence getChangeIdRepoSequence() {
        return this.changeSeq;
    }
}

