/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class AuthorizedKeys {
    public static final String FILE_NAME = "authorized_keys";
    @VisibleForTesting
    public static final String INVALID_KEY_COMMENT_PREFIX = "# INVALID ";
    @VisibleForTesting
    public static final String DELETED_KEY_COMMENT = "# DELETED";

    public static List<Optional<AccountSshKey>> parse(Account.Id accountId, String s) {
        ArrayList<Optional<AccountSshKey>> keys = new ArrayList<Optional<AccountSshKey>>();
        int seq = 1;
        for (String line : s.split("\\r?\\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            if (line.startsWith(INVALID_KEY_COMMENT_PREFIX)) {
                String pub = line.substring(INVALID_KEY_COMMENT_PREFIX.length());
                AccountSshKey key = new AccountSshKey(new AccountSshKey.Id(accountId, seq++), pub);
                key.setInvalid();
                keys.add(Optional.of(key));
                continue;
            }
            if (line.startsWith(DELETED_KEY_COMMENT)) {
                keys.add(Optional.empty());
                ++seq;
                continue;
            }
            if (line.startsWith("#")) continue;
            AccountSshKey key = new AccountSshKey(new AccountSshKey.Id(accountId, seq++), line);
            keys.add(Optional.of(key));
        }
        return keys;
    }

    public static String serialize(Collection<Optional<AccountSshKey>> keys) {
        StringBuilder b = new StringBuilder();
        for (Optional<AccountSshKey> key : keys) {
            if (key.isPresent()) {
                if (!key.get().isValid()) {
                    b.append(INVALID_KEY_COMMENT_PREFIX);
                }
                b.append(key.get().getSshPublicKey().trim());
            } else {
                b.append(DELETED_KEY_COMMENT);
            }
            b.append("\n");
        }
        return b.toString();
    }
}

