/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.IncludingGroupMembership;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class InternalGroupBackend
implements GroupBackend {
    private final GroupControl.Factory groupControlFactory;
    private final GroupCache groupCache;
    private final IncludingGroupMembership.Factory groupMembershipFactory;

    @Inject
    InternalGroupBackend(GroupControl.Factory groupControlFactory, GroupCache groupCache, IncludingGroupMembership.Factory groupMembershipFactory) {
        this.groupControlFactory = groupControlFactory;
        this.groupCache = groupCache;
        this.groupMembershipFactory = groupMembershipFactory;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return ObjectId.isId(uuid.get());
    }

    @Override
    public GroupDescription.Internal get(AccountGroup.UUID uuid) {
        if (!this.handles(uuid)) {
            return null;
        }
        AccountGroup g = this.groupCache.get(uuid);
        if (g == null) {
            return null;
        }
        return GroupDescriptions.forAccountGroup(g);
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectControl project) {
        return this.groupCache.all().stream().filter(group -> group.getName().regionMatches(true, 0, name, 0, name.length()) && this.groupControlFactory.controlFor((AccountGroup)group).isVisible()).map(GroupReference::forGroup).collect(Collectors.toList());
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return this.groupMembershipFactory.create(user);
    }

    @Override
    public boolean isVisibleToAll(AccountGroup.UUID uuid) {
        GroupDescription.Internal g = this.get(uuid);
        return g != null && g.getAccountGroup().isVisibleToAll();
    }
}

