/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.client.ListAccountsOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.api.accounts.AccountInfoComparator;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.QueryResult;
import com.google.gerrit.server.query.account.AccountQueryBuilder;
import com.google.gerrit.server.query.account.AccountQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Option;

public class QueryAccounts
implements RestReadView<TopLevelResource> {
    private static final int MAX_SUGGEST_RESULTS = 100;
    private final AccountLoader.Factory accountLoaderFactory;
    private final AccountQueryBuilder queryBuilder;
    private final AccountQueryProcessor queryProcessor;
    private final boolean suggestConfig;
    private final int suggestFrom;
    private AccountLoader accountLoader;
    private boolean suggest;
    private int suggestLimit = 10;
    private String query;
    private Integer start;
    private EnumSet<ListAccountsOption> options;

    @Option(name="--suggest", metaVar="SUGGEST", usage="suggest users")
    public void setSuggest(boolean suggest) {
        this.suggest = suggest;
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of users to return")
    public void setLimit(int n) {
        this.queryProcessor.setLimit(n);
        this.suggestLimit = n < 0 ? 10 : (n == 0 ? 100 : Math.min(n, 100));
    }

    @Option(name="-o", usage="Output options per account")
    public void addOption(ListAccountsOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListAccountsOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Option(name="--query", aliases={"-q"}, metaVar="QUERY", usage="match users")
    public void setQuery(String query) {
        this.query = query;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="Number of accounts to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Inject
    QueryAccounts(AccountLoader.Factory accountLoaderFactory, AccountQueryBuilder queryBuilder, AccountQueryProcessor queryProcessor, @GerritServerConfig Config cfg) {
        this.accountLoaderFactory = accountLoaderFactory;
        this.queryBuilder = queryBuilder;
        this.queryProcessor = queryProcessor;
        this.suggestFrom = cfg.getInt("suggest", null, "from", 0);
        this.options = EnumSet.noneOf(ListAccountsOption.class);
        if ("off".equalsIgnoreCase(cfg.getString("suggest", null, "accounts"))) {
            this.suggestConfig = false;
        } else {
            boolean suggest;
            try {
                AccountVisibility av = cfg.getEnum("suggest", null, "accounts", AccountVisibility.ALL);
                suggest = av != AccountVisibility.NONE;
            }
            catch (IllegalArgumentException err) {
                suggest = cfg.getBoolean("suggest", null, "accounts", true);
            }
            this.suggestConfig = suggest;
        }
    }

    public List<AccountInfo> apply(TopLevelResource rsrc) throws OrmException, BadRequestException, MethodNotAllowedException {
        if (Strings.isNullOrEmpty(this.query)) {
            throw new BadRequestException("missing query field");
        }
        if (this.suggest && (!this.suggestConfig || this.query.length() < this.suggestFrom)) {
            return Collections.emptyList();
        }
        EnumSet<AccountDirectory.FillOptions> fillOptions = EnumSet.of(AccountDirectory.FillOptions.ID);
        if (this.options.contains((Object)ListAccountsOption.DETAILS)) {
            fillOptions.addAll(AccountLoader.DETAILED_OPTIONS);
        }
        if (this.options.contains((Object)ListAccountsOption.ALL_EMAILS)) {
            fillOptions.add(AccountDirectory.FillOptions.EMAIL);
            fillOptions.add(AccountDirectory.FillOptions.SECONDARY_EMAILS);
        }
        if (this.suggest) {
            fillOptions.addAll(AccountLoader.DETAILED_OPTIONS);
            fillOptions.add(AccountDirectory.FillOptions.EMAIL);
            fillOptions.add(AccountDirectory.FillOptions.SECONDARY_EMAILS);
        }
        this.accountLoader = this.accountLoaderFactory.create(fillOptions);
        if (this.queryProcessor.isDisabled()) {
            throw new MethodNotAllowedException("query disabled");
        }
        if (this.start != null) {
            this.queryProcessor.setStart(this.start);
        }
        LinkedHashMap<Account.Id, AccountInfo> matches = new LinkedHashMap<Account.Id, AccountInfo>();
        try {
            Predicate<AccountState> queryPred;
            if (this.suggest) {
                queryPred = this.queryBuilder.defaultQuery(this.query);
                this.queryProcessor.setLimit(this.suggestLimit);
            } else {
                queryPred = this.queryBuilder.parse(this.query);
            }
            QueryResult<AccountState> result = this.queryProcessor.query(queryPred);
            for (AccountState accountState : result.entities()) {
                Account.Id id = accountState.getAccount().getId();
                matches.put(id, this.accountLoader.get(id));
            }
            this.accountLoader.fill();
            List<AccountInfo> sorted = AccountInfoComparator.ORDER_NULLS_LAST.sortedCopy(matches.values());
            if (!sorted.isEmpty() && result.more()) {
                sorted.get((int)(sorted.size() - 1))._moreAccounts = true;
            }
            return sorted;
        }
        catch (QueryParseException e) {
            if (this.suggest) {
                return ImmutableList.of();
            }
            throw new BadRequestException(e.getMessage());
        }
    }
}

