/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.accounts;

import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.api.accounts.AccountApi;
import com.google.gerrit.extensions.api.accounts.AccountInput;
import com.google.gerrit.extensions.api.accounts.Accounts;
import com.google.gerrit.extensions.client.ListAccountsOption;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.CapabilityUtils;
import com.google.gerrit.server.account.CreateAccount;
import com.google.gerrit.server.account.QueryAccounts;
import com.google.gerrit.server.api.accounts.AccountApiImpl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class AccountsImpl
implements Accounts {
    private final AccountsCollection accounts;
    private final AccountApiImpl.Factory api;
    private final Provider<CurrentUser> self;
    private final CreateAccount.Factory createAccount;
    private final Provider<QueryAccounts> queryAccountsProvider;

    @Inject
    AccountsImpl(AccountsCollection accounts, AccountApiImpl.Factory api, Provider<CurrentUser> self, CreateAccount.Factory createAccount, Provider<QueryAccounts> queryAccountsProvider) {
        this.accounts = accounts;
        this.api = api;
        this.self = self;
        this.createAccount = createAccount;
        this.queryAccountsProvider = queryAccountsProvider;
    }

    @Override
    public AccountApi id(String id) throws RestApiException {
        try {
            return this.api.create(this.accounts.parse(TopLevelResource.INSTANCE, IdString.fromDecoded(id)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot parse change", e);
        }
    }

    @Override
    public AccountApi id(int id) throws RestApiException {
        return this.id(String.valueOf(id));
    }

    @Override
    public AccountApi self() throws RestApiException {
        if (!this.self.get().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.api.create(new AccountResource(this.self.get().asIdentifiedUser()));
    }

    @Override
    public AccountApi create(String username) throws RestApiException {
        AccountInput in = new AccountInput();
        in.username = username;
        return this.create(in);
    }

    @Override
    public AccountApi create(AccountInput in) throws RestApiException {
        if (Preconditions.checkNotNull(in, (Object)"AccountInput").username == null) {
            throw new BadRequestException("AccountInput must specify username");
        }
        CapabilityUtils.checkRequiresCapability(this.self, null, CreateAccount.class);
        try {
            AccountInfo info = this.createAccount.create(in.username).apply(TopLevelResource.INSTANCE, in).value();
            return this.id(info._accountId);
        }
        catch (OrmException | IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot create account " + in.username, e);
        }
    }

    @Override
    public Accounts.SuggestAccountsRequest suggestAccounts() throws RestApiException {
        return new Accounts.SuggestAccountsRequest(){

            @Override
            public List<AccountInfo> get() throws RestApiException {
                return AccountsImpl.this.suggestAccounts(this);
            }
        };
    }

    @Override
    public Accounts.SuggestAccountsRequest suggestAccounts(String query) throws RestApiException {
        return this.suggestAccounts().withQuery(query);
    }

    private List<AccountInfo> suggestAccounts(Accounts.SuggestAccountsRequest r) throws RestApiException {
        try {
            QueryAccounts myQueryAccounts = this.queryAccountsProvider.get();
            myQueryAccounts.setSuggest(true);
            myQueryAccounts.setQuery(r.getQuery());
            myQueryAccounts.setLimit(r.getLimit());
            return myQueryAccounts.apply(TopLevelResource.INSTANCE);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve suggested accounts", e);
        }
    }

    @Override
    public Accounts.QueryRequest query() throws RestApiException {
        return new Accounts.QueryRequest(){

            @Override
            public List<AccountInfo> get() throws RestApiException {
                return AccountsImpl.this.query(this);
            }
        };
    }

    @Override
    public Accounts.QueryRequest query(String query) throws RestApiException {
        return this.query().withQuery(query);
    }

    private List<AccountInfo> query(Accounts.QueryRequest r) throws RestApiException {
        try {
            QueryAccounts myQueryAccounts = this.queryAccountsProvider.get();
            myQueryAccounts.setQuery(r.getQuery());
            myQueryAccounts.setLimit(r.getLimit());
            myQueryAccounts.setStart(r.getStart());
            for (ListAccountsOption option : r.getOptions()) {
                myQueryAccounts.addOption(option);
            }
            return myQueryAccounts.apply(TopLevelResource.INSTANCE);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve suggested accounts", e);
        }
    }
}

