/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.BatchUpdateReviewDb;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoContext;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

class DeleteChangeOp
implements BatchUpdateOp {
    private final PatchSetUtil psUtil;
    private final StarredChangesUtil starredChangesUtil;
    private final DynamicItem<AccountPatchReviewStore> accountPatchReviewStore;
    private final boolean allowDrafts;
    private Change.Id id;

    static boolean allowDrafts(Config cfg) {
        return cfg.getBoolean("change", "allowDrafts", true);
    }

    static ReviewDb unwrap(ReviewDb db) {
        if (db instanceof BatchUpdateReviewDb) {
            db = ((BatchUpdateReviewDb)db).unsafeGetDelegate();
        }
        return ReviewDbUtil.unwrapDb(db);
    }

    @Inject
    DeleteChangeOp(PatchSetUtil psUtil, StarredChangesUtil starredChangesUtil, DynamicItem<AccountPatchReviewStore> accountPatchReviewStore, @GerritServerConfig Config cfg) {
        this.psUtil = psUtil;
        this.starredChangesUtil = starredChangesUtil;
        this.accountPatchReviewStore = accountPatchReviewStore;
        this.allowDrafts = DeleteChangeOp.allowDrafts(cfg);
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException, NoSuchChangeException {
        Preconditions.checkState(ctx.getOrder() == Order.DB_BEFORE_REPO, "must use DeleteChangeOp with DB_BEFORE_REPO");
        Preconditions.checkState(this.id == null, "cannot reuse DeleteChangeOp");
        this.id = ctx.getChange().getId();
        ImmutableCollection<PatchSet> patchSets = this.psUtil.byChange(ctx.getDb(), ctx.getNotes());
        this.ensureDeletable(ctx, this.id, patchSets);
        this.cleanUpReferences(ctx, this.id, patchSets);
        this.deleteChangeElementsFromDb(ctx, this.id);
        ctx.deleteChange();
        return true;
    }

    private void ensureDeletable(ChangeContext ctx, Change.Id id, Collection<PatchSet> patchSets) throws ResourceConflictException, MethodNotAllowedException, OrmException, AuthException, IOException {
        Change.Status status = ctx.getChange().getStatus();
        if (status == Change.Status.MERGED) {
            throw new MethodNotAllowedException("Deleting merged change " + id + " is not allowed");
        }
        for (PatchSet patchSet : patchSets) {
            if (!this.isPatchSetMerged(ctx, patchSet)) continue;
            throw new ResourceConflictException(String.format("Cannot delete change %s: patch set %s is already merged", id, patchSet.getPatchSetId()));
        }
        if (!ctx.getControl().canDelete(ctx.getDb(), status)) {
            throw new AuthException("Deleting change " + id + " is not permitted");
        }
        if (status == Change.Status.DRAFT) {
            if (!this.allowDrafts && !ctx.getControl().isAdmin()) {
                throw new MethodNotAllowedException("Draft workflow is disabled");
            }
            for (PatchSet ps : patchSets) {
                if (ps.isDraft()) continue;
                throw new ResourceConflictException("Cannot delete draft change " + id + ": patch set " + ps.getPatchSetId() + " is not a draft");
            }
        }
    }

    private boolean isPatchSetMerged(ChangeContext ctx, PatchSet patchSet) throws IOException {
        Repository repository = ctx.getRepository();
        Ref destinationRef = repository.exactRef(ctx.getChange().getDest().get());
        if (destinationRef == null) {
            return false;
        }
        RevWalk revWalk = ctx.getRevWalk();
        ObjectId objectId = ObjectId.fromString(patchSet.getRevision().get());
        RevCommit revCommit = revWalk.parseCommit(objectId);
        return IncludedInResolver.includedInOne(repository, revWalk, revCommit, Collections.singletonList(destinationRef));
    }

    private void deleteChangeElementsFromDb(ChangeContext ctx, Change.Id id) throws OrmException {
        ReviewDb db = DeleteChangeOp.unwrap(ctx.getDb());
        db.patchComments().delete(db.patchComments().byChange(id));
        db.patchSetApprovals().delete(db.patchSetApprovals().byChange(id));
        db.patchSets().delete(db.patchSets().byChange(id));
        db.changeMessages().delete(db.changeMessages().byChange(id));
    }

    private void cleanUpReferences(ChangeContext ctx, Change.Id id, Collection<PatchSet> patchSets) throws OrmException, NoSuchChangeException {
        for (PatchSet ps : patchSets) {
            this.accountPatchReviewStore.get().clearReviewed(ps.getId());
        }
        this.starredChangesUtil.unstarAll(ctx.getChange().getProject(), id);
    }

    @Override
    public void updateRepo(RepoContext ctx) throws IOException {
        String prefix = new PatchSet.Id(this.id, 1).toRefName();
        prefix = prefix.substring(0, prefix.length() - 1);
        for (Ref ref : ctx.getRepository().getRefDatabase().getRefs(prefix).values()) {
            ctx.addRefUpdate(new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), ref.getName()));
        }
    }
}

