/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.restapi.ETagView;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ActionJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ChangeSet;
import com.google.gerrit.server.git.MergeSuperSet;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.lib.Config;

@Singleton
public class GetRevisionActions
implements ETagView<RevisionResource> {
    private final ActionJson delegate;
    private final Config config;
    private final Provider<ReviewDb> dbProvider;
    private final Provider<MergeSuperSet> mergeSuperSet;
    private final ChangeResource.Factory changeResourceFactory;

    @Inject
    GetRevisionActions(ActionJson delegate, Provider<ReviewDb> dbProvider, Provider<MergeSuperSet> mergeSuperSet, ChangeResource.Factory changeResourceFactory, @GerritServerConfig Config config) {
        this.delegate = delegate;
        this.dbProvider = dbProvider;
        this.mergeSuperSet = mergeSuperSet;
        this.changeResourceFactory = changeResourceFactory;
        this.config = config;
    }

    public Response<Map<String, ActionInfo>> apply(RevisionResource rsrc) throws OrmException {
        return Response.withMustRevalidate(this.delegate.format(rsrc));
    }

    @Override
    public String getETag(RevisionResource rsrc) {
        Hasher h = Hashing.md5().newHasher();
        CurrentUser user = rsrc.getControl().getUser();
        try {
            rsrc.getChangeResource().prepareETag(h, user);
            h.putBoolean(Submit.wholeTopicEnabled(this.config));
            ReviewDb db = this.dbProvider.get();
            ChangeSet cs = this.mergeSuperSet.get().completeChangeSet(db, rsrc.getChange(), user);
            for (ChangeData cd : cs.changes()) {
                this.changeResourceFactory.create(cd.changeControl()).prepareETag(h, user);
            }
            h.putBoolean(cs.furtherHiddenChanges());
        }
        catch (OrmException | IOException e) {
            throw new OrmRuntimeException(e);
        }
        return h.hash().toString();
    }
}

