/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Index
implements RestModifyView<ChangeResource, Input> {
    private final Provider<ReviewDb> db;
    private final ChangeIndexer indexer;

    @Inject
    Index(Provider<ReviewDb> db, ChangeIndexer indexer) {
        this.db = db;
        this.indexer = indexer;
    }

    public Response<?> apply(ChangeResource rsrc, Input input) throws IOException, AuthException, OrmException {
        ChangeControl ctl = rsrc.getControl();
        if (!ctl.isOwner() && !ctl.getUser().getCapabilities().canMaintainServer()) {
            throw new AuthException("Only change owner or server maintainer can reindex");
        }
        this.indexer.index(this.db.get(), rsrc.getChange());
        return Response.none();
    }

    public static class Input {
    }
}

