/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;

@Singleton
public class ListChangeComments
implements RestReadView<ChangeResource> {
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final Provider<CommentJson> commentJson;
    private final CommentsUtil commentsUtil;

    @Inject
    ListChangeComments(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
    }

    public Map<String, List<CommentInfo>> apply(ChangeResource rsrc) throws AuthException, OrmException {
        ChangeData cd = this.changeDataFactory.create(this.db.get(), rsrc.getControl());
        return this.commentJson.get().setFillAccounts(true).setFillPatchSet(true).newCommentFormatter().format(this.commentsUtil.publishedByChange(this.db.get(), cd.notes()));
    }
}

