/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.change.ReviewerJson;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;
import java.util.List;

@Singleton
class ListRevisionReviewers
implements RestReadView<RevisionResource> {
    private final Provider<ReviewDb> dbProvider;
    private final ApprovalsUtil approvalsUtil;
    private final ReviewerJson json;
    private final ReviewerResource.Factory resourceFactory;

    @Inject
    ListRevisionReviewers(Provider<ReviewDb> dbProvider, ApprovalsUtil approvalsUtil, ReviewerResource.Factory resourceFactory, ReviewerJson json) {
        this.dbProvider = dbProvider;
        this.approvalsUtil = approvalsUtil;
        this.resourceFactory = resourceFactory;
        this.json = json;
    }

    public List<ReviewerInfo> apply(RevisionResource rsrc) throws OrmException, MethodNotAllowedException {
        if (!rsrc.isCurrent()) {
            throw new MethodNotAllowedException("Cannot list reviewers on non-current patch set");
        }
        LinkedHashMap<Account.Id, ReviewerResource> reviewers = new LinkedHashMap<Account.Id, ReviewerResource>();
        ReviewDb db = this.dbProvider.get();
        for (Account.Id accountId : this.approvalsUtil.getReviewers(db, rsrc.getNotes()).all()) {
            if (reviewers.containsKey(accountId)) continue;
            reviewers.put(accountId, this.resourceFactory.create(rsrc, accountId));
        }
        return this.json.format(reviewers.values());
    }
}

