/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.ChangeRestored;
import com.google.gerrit.server.mail.send.RestoredSender;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Restore
implements RestModifyView<ChangeResource, RestoreInput>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Restore.class);
    private final RestoredSender.Factory restoredSenderFactory;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeJson.Factory json;
    private final ChangeMessagesUtil cmUtil;
    private final PatchSetUtil psUtil;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final ChangeRestored changeRestored;

    @Inject
    Restore(RestoredSender.Factory restoredSenderFactory, Provider<ReviewDb> dbProvider, ChangeJson.Factory json, ChangeMessagesUtil cmUtil, PatchSetUtil psUtil, BatchUpdate.Factory batchUpdateFactory, ChangeRestored changeRestored) {
        this.restoredSenderFactory = restoredSenderFactory;
        this.dbProvider = dbProvider;
        this.json = json;
        this.cmUtil = cmUtil;
        this.psUtil = psUtil;
        this.batchUpdateFactory = batchUpdateFactory;
        this.changeRestored = changeRestored;
    }

    public ChangeInfo apply(ChangeResource req, RestoreInput input) throws RestApiException, UpdateException, OrmException {
        ChangeControl ctl = req.getControl();
        if (!ctl.canRestore(this.dbProvider.get())) {
            throw new AuthException("restore not permitted");
        }
        Op op = new Op(input);
        try (BatchUpdate u = this.batchUpdateFactory.create(this.dbProvider.get(), req.getChange().getProject(), ctl.getUser(), TimeUtil.nowTs());){
            u.addOp(req.getId(), op).execute();
        }
        return this.json.noOptions().format(op.change);
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        boolean canRestore = false;
        try {
            canRestore = resource.getControl().canRestore(this.dbProvider.get());
        }
        catch (OrmException e) {
            log.error("Cannot check canRestore status. Assuming false.", e);
        }
        return new UiAction.Description().setLabel("Restore").setTitle("Restore the change").setVisible(resource.getChange().getStatus() == Change.Status.ABANDONED && canRestore);
    }

    private static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }

    private class Op
    implements BatchUpdateOp {
        private final RestoreInput input;
        private Change change;
        private PatchSet patchSet;
        private ChangeMessage message;

        private Op(RestoreInput input) {
            this.input = input;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException, ResourceConflictException {
            this.change = ctx.getChange();
            if (this.change == null || this.change.getStatus() != Change.Status.ABANDONED) {
                throw new ResourceConflictException("change is " + Restore.status(this.change));
            }
            PatchSet.Id psId = this.change.currentPatchSetId();
            ChangeUpdate update = ctx.getUpdate(psId);
            this.patchSet = Restore.this.psUtil.get(ctx.getDb(), ctx.getNotes(), psId);
            this.change.setStatus(Change.Status.NEW);
            this.change.setLastUpdatedOn(ctx.getWhen());
            update.setStatus(this.change.getStatus());
            this.message = this.newMessage(ctx);
            Restore.this.cmUtil.addChangeMessage(ctx.getDb(), update, this.message);
            return true;
        }

        private ChangeMessage newMessage(ChangeContext ctx) {
            StringBuilder msg = new StringBuilder();
            msg.append("Restored");
            if (!Strings.nullToEmpty(this.input.message).trim().isEmpty()) {
                msg.append("\n\n");
                msg.append(this.input.message.trim());
            }
            return ChangeMessagesUtil.newMessage(ctx, msg.toString(), "autogenerated:gerrit:restore");
        }

        @Override
        public void postUpdate(Context ctx) throws OrmException {
            try {
                RestoredSender cm = Restore.this.restoredSenderFactory.create(ctx.getProject(), this.change.getId());
                cm.setFrom(ctx.getAccountId());
                cm.setChangeMessage(this.message.getMessage(), ctx.getWhen());
                cm.send();
            }
            catch (Exception e) {
                log.error("Cannot email update for change " + this.change.getId(), e);
            }
            Restore.this.changeRestored.fire(this.change, this.patchSet, ctx.getAccount(), Strings.emptyToNull(this.input.message), ctx.getWhen());
        }
    }
}

