/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ServerRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.Provider;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupSetProvider
implements Provider<Set<AccountGroup.UUID>> {
    protected Set<AccountGroup.UUID> groupIds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GroupSetProvider(GroupBackend groupBackend, ThreadLocalRequestContext threadContext, ServerRequestContext serverCtx, List<String> groupNames) {
        RequestContext ctx = threadContext.setContext(serverCtx);
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (String n : groupNames) {
                GroupReference g = GroupBackends.findBestSuggestion(groupBackend, n);
                if (g != null) {
                    builder.add(g.getUUID());
                    continue;
                }
                Logger log = LoggerFactory.getLogger(this.getClass());
                log.warn("Group \"{}\" not available, skipping.", (Object)n);
            }
            this.groupIds = builder.build();
        }
        finally {
            threadContext.setContext(ctx);
        }
    }

    @Override
    public Set<AccountGroup.UUID> get() {
        return this.groupIds;
    }
}

